package com.shitu.location.epathmap.model.parse;

import com.shitu.location.epathmap.utils.ParseClass;
import com.parse.ParseClassName;
import com.parse.ParseGeoPoint;
import com.parse.ParseObject;

/**
 * author:lfei
 */

@ParseClassName(ParseClass.LocationShare)
public class LocationShare extends ParseObject {

    public static final String USER_NAME = "userName";
    public static final String DEVICE_ID = "deviceId";
    public static final String FLOOR = "floor";
    public static final String LOCATION = "location";
    public static final String GROUP_ID = "groupId";
    public static final String IS_QUIT = "isQuit";
    public static final String PROJECT = "project";
    public static final String OWNER = "owner";
    public static final String UPDATED_AT = "updatedAt";
    public static final String CREATED_AT = "createdAt";

    public String getUserName(){
        return getString(USER_NAME);
    }

    public String getDeviceId(){
        return getString(DEVICE_ID);
    }

    public ParseGeoPoint getLocation(){
        return getParseGeoPoint(LOCATION);
    }

    public String getGroupId(){
        return getString(GROUP_ID);
    }

    public boolean isQuit(){
        return getBoolean(IS_QUIT);
    }

    public ParseObject getProject(){
        return getParseObject(PROJECT);
    }

    public String getFloor(){
        return getString(FLOOR);
    }

    public boolean isOwner() {
        return getBoolean(OWNER);
    }

}
