/*
 * Decompiled with CFR 0.152.
 */
package com.shitu.location.uploadlocation;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.shitu.location.uploadlocation.AbsWorkService;
import java.util.HashMap;
import java.util.Map;

public final class DaemonEnv {
    public static final int DEFAULT_WAKE_UP_INTERVAL = 1000;
    private static final int MINIMAL_WAKE_UP_INTERVAL = 180000;
    static final Map<Class<? extends Service>, Boolean> BIND_STATE_MAP = new HashMap<Class<? extends Service>, Boolean>();
    static Context sApp;
    static Class<? extends AbsWorkService> sServiceClass;
    private static int sWakeUpInterval;
    public static boolean sInitialized;

    private DaemonEnv() {
    }

    public static void initialize(@NonNull Context context, @NonNull Class<? extends AbsWorkService> clazz, @Nullable Integer n2) {
        sApp = context;
        sServiceClass = clazz;
        if (n2 != null) {
            sWakeUpInterval = n2;
        }
        sInitialized = true;
    }

    public static void startServiceMayBind(final @NonNull Class<? extends Service> clazz) {
        if (!sInitialized) {
            return;
        }
        final Intent intent = new Intent(sApp, clazz);
        DaemonEnv.startServiceSafely(intent);
        Boolean bl = BIND_STATE_MAP.get(clazz);
        if (bl == null || !bl.booleanValue()) {
            sApp.bindService(intent, new ServiceConnection(){

                public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                    BIND_STATE_MAP.put(clazz, true);
                }

                public void onServiceDisconnected(ComponentName componentName) {
                    BIND_STATE_MAP.put(clazz, false);
                    DaemonEnv.startServiceSafely(intent);
                    if (!sInitialized) {
                        return;
                    }
                    sApp.bindService(intent, (ServiceConnection)this, 1);
                }
            }, 1);
        }
    }

    public static void startServiceSafely(Intent intent) {
        if (!sInitialized) {
            return;
        }
        try {
            sApp.startService(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static int getWakeUpInterval() {
        return Math.max(sWakeUpInterval, 180000);
    }

    static {
        sWakeUpInterval = 1000;
    }
}

