package com.shitu.location.uploadlocation;

import com.shitu.location.epathmap.EpathClient;
import com.shitu.location.epathmap.model.bean.BackgroundData;
import com.shitu.location.epathmap.model.parse.Background;
import com.shitu.location.epathmap.utils.IpsException;
import com.shitu.location.epathmap.utils.L;
import com.parse.ParseException;
import com.parse.ParseObject;
import com.parse.ParseQuery;

import java.util.ArrayList;
import java.util.List;

/**
 * author:lfei
 */
public class EpathGetUserBackGroundDatas {

    private int page = 1, limit = 30;

    private List<BackgroundData> backgroundDatas = new ArrayList<>();


    public EpathGetUserBackGroundDatas() {
    }

    public void handleError(ParseException e) {
        e.printStackTrace();
        IpsException ipsException = new IpsException(e, e.getCode());
        if (EpathClient.userAllBackgroundDataListener != null){
            EpathClient.userAllBackgroundDataListener.onError(ipsException);
        }

//
//        if (isViewAttached()) {
//            getView().handleThrowable(ipsException);
//        }
    }

    public void queryBackgroundData(String mapId, String deviceId) {
        ArrayList<BackgroundData> newBackgroundDatas = new ArrayList<>();
        ParseQuery.getQuery(Background.class)
                .whereEqualTo("project", ParseObject.createWithoutData("MappingProject", mapId))
                .whereEqualTo(Background.deviceId, deviceId)
                .orderByAscending(Background.enterAt)
                .setLimit(limit)
                .setSkip(limit * (page - 1))
                .findInBackground((objects, e) -> {
                    if (e != null) {
                        handleError(e);
                        return;
                    }
                    for (int i = 0; i < objects.size(); i++) {
                        Background background = objects.get(i);
                        BackgroundData backgroundData = new BackgroundData();
                        backgroundData.setLocationRegion(background.getLocationRegion());
                        backgroundData.setLocationRegions((ArrayList) background.getLocationRegions());
                        backgroundData.setFloorName(background.getFloorName());
                        backgroundData.setEnterAt(background.getEnterAt());
                        backgroundData.setLeaveAt(background.getLeaveAt());
                        backgroundData.setLonLat(background.getLonLat());
                        backgroundData.setDurationTime(background.getDurationTime());
                        backgroundData.setUserDescription(background.getUserDescription());
                        backgroundData.setPhoneNumber(background.getPhoneNumber());
                        backgroundData.setDeviceId(background.getDeviceId());
                        newBackgroundDatas.add(backgroundData);
                    }
//                    handleData(newBackgroundDatas);
                    if (EpathClient.userAllBackgroundDataListener!= null){
                        EpathClient.userAllBackgroundDataListener.onSuccess(newBackgroundDatas);
                    }else {
                        L.e("ipsmap","ipsmap client userAllBackgroundDataListener not init!");
                    }

                });
    }



    public int getPage() {
        return page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public boolean hasNext() {
        int size = backgroundDatas.size();
        return (size != 0 && size == page * limit) ? true : false;
    }

}
