package com.shitu.location.epathmap;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;


import com.parse.ParseObject;
import com.shitu.location.R;
import com.shitu.location.epathmap.model.parse.App;
import com.shitu.location.epathmap.model.parse.POI;
import com.shitu.location.epathmap.model.parse.Project;
import com.shitu.location.epathmap.model.parse.Punch;
import com.shitu.location.epathmap.utils.Constants;
import com.shitu.location.epathmap.utils.IpsUtils;
import com.shitu.location.epathmap.utils.L;
import com.shitu.location.epathmap.utils.T;
import com.shitu.location.uploadlocation.EpathGetUserBackGroundDatas;
import com.shitu.location.uploadlocation.UserAllBackgroundDataListener;
import com.parse.ParseException;
import com.parse.ParseGeoPoint;
import com.parse.ParseQuery;
import com.sails.engine.LocationRegion;
import com.sails.engine.SAILS;
import com.sails.engine.SAILSMapView;
import com.sails.engine.core.model.GeoPoint;

import java.util.ArrayList;
import java.util.List;

/**
 * author:lfei
 */
public class EpathClient {

    private static final int MSG_START_ENGINE = 0, MSG_LOCATION_WAIT = 1, MSG_SEND_LOCATION = 2;
    private static final int TIME_OUT = 10000;
    private SAILS sails;
    private SAILSMapView sailsMapView;
    private Project project;
    private String mapId;
    private boolean isFirstQueryMap = true, isFirstLocationFix = true;
    private EpathLocationListener epathLocationListener;
    private MyHandler handler;

    private String userId;
    private App app;
    private Context context;
    public static UserAllBackgroundDataListener userAllBackgroundDataListener;

    public EpathClient(Context context, String mapId) {
        this.mapId = mapId;
        this.context = context;
        handler = new MyHandler();
        sails = new SAILS(context);
        sails.setServerURL(Constants.CLOUD_SERVER_URL);
        sailsMapView = new SAILSMapView(context);
        sailsMapView.setSAILSEngine(sails);
    }

    public EpathClient(Context context, String mapId, String userId) {
        this.userId = userId;
        this.mapId = mapId;
        handler = new MyHandler();
        sails = new SAILS(context);
        sails.setServerURL(Constants.CLOUD_SERVER_URL);
        sailsMapView = new SAILSMapView(context);
        sailsMapView.setSAILSEngine(sails);
    }

    public void registerLocationListener(EpathLocationListener epathLocationListener) {
        this.epathLocationListener = epathLocationListener;
    }

    public void registerUserAllLocationDataListener(UserAllBackgroundDataListener userAllBackgroundDataListener) {
        this.userAllBackgroundDataListener = userAllBackgroundDataListener;
    }


    public void getUserAllLocationData(String userId, int page, String mapId) {
        if (TextUtils.isEmpty(mapId)) {
            mapId = "05rQwjfdSO";
        }
        //userId deviceId
//        TODO
        EpathGetUserBackGroundDatas epathGetUserBackGroundDatas = new EpathGetUserBackGroundDatas();
        epathGetUserBackGroundDatas.setPage(page);
        epathGetUserBackGroundDatas.queryBackgroundData(mapId, IpsUtils.getDeviceID());

    }

    public void start() {
        if (handler.hasMessages(MSG_LOCATION_WAIT) || handler.hasMessages(MSG_SEND_LOCATION)) {
            return;
        }
        if (sails != null && project != null && sails.isLocationFix() && epathLocationListener != null) {
            handler.sendEmptyMessageDelayed(MSG_SEND_LOCATION, 500);
        } else if (sails != null && project != null && !sails.isLocationFix() && epathLocationListener != null) {
            handler.sendEmptyMessageDelayed(MSG_LOCATION_WAIT, TIME_OUT);
        } else {
            loadCloudBuilding();
        }

    }

    public void stop() {
        stopLocation();
        handler.removeMessages(MSG_START_ENGINE);
        handler.removeMessages(MSG_LOCATION_WAIT);
    }

    private void loadCloudBuilding() {
        isFirstQueryMap = true;
        if (EpathLocationSDK.app != null) {
            app = EpathLocationSDK.app;
            ParseQuery<Project> query = EpathLocationSDK.app.getProjects().getQuery();
            query.whereEqualTo("visible", true);
            query.setCachePolicy(ParseQuery.CachePolicy.CACHE_THEN_NETWORK);
            query.findInBackground((objects, e) -> {
                if (e != null) {
                    e.printStackTrace();
                    if (e.getCode() != ParseException.CACHE_MISS && isFirstQueryMap) {
                        T.showShort(R.string.ips_location_no_permission_read_this_map);
                    }
                    return;
                }
                if (!isFirstQueryMap) {
                    return;
                }
                isFirstQueryMap = false;
                for (int i = 0; i < objects.size(); i++) {
                    Project project = objects.get(i);
                    if (project.getObjectId().equals(mapId)) {
                        this.project = project;
                        break;
                    }
                }
                if (this.project == null) {
                    T.showShort(R.string.ips_location_no_permission_read_this_map);
                    return;
                }
                if (project.getBuildingId().isEmpty() || project.getToken().isEmpty()) {
                    T.showShort(R.string.ips_lcoation_info_lack);
                    return;
                }
                sails.setOnLocationChangeEventListener(() -> {
                    if (sails.isLocationFix() && handler.hasMessages(MSG_LOCATION_WAIT)) {
                        if (epathLocationListener != null) {
                            handler.sendEmptyMessageDelayed(MSG_SEND_LOCATION, 500);
                            handler.removeMessages(MSG_LOCATION_WAIT);
                            isFirstLocationFix = false;
                        }
                    }
                    if (sails.isLocationFix() && isFirstLocationFix) {
                        isFirstLocationFix = false;
                        sailsMapView.loadFloorMap(project.getGpsFloorlayer() + "");
                        if (epathLocationListener != null) {
                            handler.sendEmptyMessageDelayed(MSG_SEND_LOCATION, 500);
                        }
                    }
                });

                sails.loadCloudBuilding(project.getToken(), project.getBuildingId(), new SAILS.OnFinishCallback() {
                    @Override
                    public void onSuccess(String response) {
                        handler.sendEmptyMessage(MSG_START_ENGINE);
                    }

                    @Override
                    public void onFailed(String response) {

                    }
                });
            });
        } else {
            T.showShort(R.string.ips_location_init_ipsmap_fail);
            return;
        }
    }

    private void startLocation() {
        if (sails != null) {
            sails.setGPSFloorLayer(project.getGpsFloorlayer() + "");
            sails.setGPSThresholdParameter(project.getInToOut(), project.getOutToIn(), project.getPowerThreshold()); //in_to_out,out_to_in,beacon min power
            sails.setEnvironmentIsHighBeaconDensity(true);//v1.51
            sails.setMode(SAILS.BLE_GFP_IMU | SAILS.WITH_GPS);
            sails.startLocatingEngine();
            handler.sendEmptyMessageDelayed(MSG_LOCATION_WAIT, TIME_OUT);
        }
    }

    /**
     * 判断是否在一个指定的范围内,默认6米
     *
     * @param mapId    分配的地图ID
     * @param targetId 目标UUID
     */
    public void startCheckLocationRange(String mapId, String targetId) {
        startCheckLocationRange(mapId, targetId, 12);
    }

    /**
     * 判断是否在一个指定的范围内
     *
     * @param mapId    分配的地图ID
     * @param targetId 目标UUID
     * @param distance 打卡距离
     */
    public void startCheckLocationRange(String mapId, String targetId, int distance) {
        ParseObject parseObject = ParseObject.createWithoutData("MappingProject", mapId);
        ParseQuery.getQuery(POI.class)
                .whereEqualTo("project", parseObject)
                .whereEqualTo("link", targetId)
                .orderByAscending("floor")
                .getFirstInBackground((object, e) -> {

                    double lat = object.getLatitude();
                    double lng = object.getLongitude();
                    String floorName = object.getFloorName();    //目标所在的楼层
                    String currentFloorName = sails.getFloor();  //用户所在楼层
                    //判断是否在同一楼层
                    if (floorName != null && currentFloorName != null && floorName.equals(currentFloorName)) {
                        //获取两点的间距
                        double rangeDistance = sails.getMapDistanceByLngLat(lat,
                                lng,
                                sails.getLatitude(),
                                sails.getLongitude());
                        if ((int) rangeDistance < distance) {
                            epathLocationListener.onReceiveRange(true);
                            return;
                        }
                    } else {
                        return;
                    }
                });
    }

    private void stopLocation() {
        if (sails != null && sails.isLocationEngineStarted()) {
            sails.stopLocatingEngine();
        }
    }

    private String getNearestLocationRegion() {
        List<LocationRegion> locationRegionList = sails.getCurrentInRegions();
        String lr;
        if (locationRegionList != null && locationRegionList.size() > 0) {
            LocationRegion locationRegion = locationRegionList.get(0);
            String type = locationRegion.type;
            if (type != null && (type.equals("freedom") || type.equals("boundary") || type.equals("lock"))) {
                lr = getNearestLocationRegionFromAll();
            } else {
                lr = locationRegionList.get(0).label;
            }
        } else {
            lr = getNearestLocationRegionFromAll();
        }
        return lr;
    }

    private String getNearestLocationRegionFromAll() {
        String lr = "";
        ArrayList<LocationRegion> allRegionList = getAllRegionList();
        if (sails.isInThisBuilding() && allRegionList != null) {
            List<LocationRegion> locationRegions = sails.sortLocationRegionsByPathLength(allRegionList);
            if (locationRegions != null && locationRegions.size() > 0) {
                lr = locationRegions.get(0).label;
            }
        }
        return lr;
    }

    private ArrayList<LocationRegion> getAllRegionList() {
        ArrayList<LocationRegion> AllLocationRegionList = new ArrayList<>();
        List<String> floorNameList = sails.getFloorNameList();
        if (floorNameList != null) {
            for (String s : floorNameList) {
                List<LocationRegion> locationRegionList = sails.getLocationRegionList(s);
                if (locationRegionList != null) {
                    for (LocationRegion locationRegion : locationRegionList) {
                        if (locationRegion.type != null) {
                            String type = locationRegion.type;
                            if (type.equals("freedom") || type.equals("boundary") || type.equals("lock")) {
                                continue;
                            }
                        }
                        AllLocationRegionList.add(locationRegion);
                    }
                }

            }
        }
        return AllLocationRegionList;
    }

    private void uploadPunch(String lr, boolean isInThisMap) {
        if (isInThisMap && project != null && app != null) {
            Punch punch = new Punch();
            punch.put(Punch.floor, sails.getFloor());
            if (!TextUtils.isEmpty(lr)) {
                punch.put(Punch.locationRegion, lr);
            }
            punch.put(Punch.lonLat, new ParseGeoPoint(sails.getLatitude(), sails.getLongitude()));
            if (userId != null) {
                punch.put(Punch.userId, userId);
            }
            punch.put(Punch.project, project);
            punch.put(Punch.app, app);
            punch.put(Punch.appName, Constants.getAppName(EpathLocationSDK.context));
            punch.saveInBackground(e -> {
                if (e != null) {
                    L.e("上传打卡数据失败", e.getCause() + "  " + e.getMessage());
                } else {
                    L.e("上传打卡数据成功", "上传打卡数据成功");
                }
            });
        }
    }

    private void sendLocation() {
        EpathLocation ipsLocation = new EpathLocation();
        ipsLocation.setFloor(sails.getFloor());
        ipsLocation.setFloorDescription(sails.getFloorDescription(sails.getFloor()));
        boolean isInThisMap = sailsMapView.isInMap(new GeoPoint(sails.getLatitude(), sails.getLongitude()));
        ipsLocation.setInThisMap(isInThisMap);
        String lr = getNearestLocationRegion();
        if (!TextUtils.isEmpty(lr)) {
            ipsLocation.setNearLocationRegion(lr);
        }
        epathLocationListener.onReceiveLocation(ipsLocation);
        uploadPunch(lr, isInThisMap);
    }


    private class MyHandler extends Handler {
        public MyHandler() {
        }

        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case MSG_START_ENGINE:
                    startLocation();
                    break;
                case MSG_LOCATION_WAIT:
                    if (epathLocationListener != null && !sails.isLocationFix()) {
                        epathLocationListener.onReceiveLocation(null);
                    }
                    break;
                case MSG_SEND_LOCATION:
                    sendLocation();
                    break;
            }
        }
    }

}
