/*
 * Decompiled with CFR 0.152.
 */
package com.shitu.location.epathmap.utils;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.WindowManager;

public class DensityUtils {
    private DensityUtils() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static int dp2px(Context context, float f2) {
        return (int)TypedValue.applyDimension((int)1, (float)f2, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static int sp2px(Context context, float f2) {
        return (int)TypedValue.applyDimension((int)2, (float)f2, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static float px2dp(Context context, float f2) {
        float f3 = context.getResources().getDisplayMetrics().density;
        return f2 / f3;
    }

    public static float px2sp(Context context, float f2) {
        return f2 / context.getResources().getDisplayMetrics().scaledDensity;
    }

    public static int getViewMeasuredHeight(View view) {
        DensityUtils.calcViewMeasure(view);
        return view.getMeasuredHeight();
    }

    public static int getViewMeasuredWidth(View view) {
        DensityUtils.calcViewMeasure(view);
        return view.getMeasuredWidth();
    }

    public static void calcViewMeasure(View view) {
        int n2 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int n3 = View.MeasureSpec.makeMeasureSpec((int)0x1FFFFFFF, (int)Integer.MIN_VALUE);
        view.measure(n2, n3);
    }

    public static int getScreenWidth(Context context) {
        return ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getWidth();
    }

    public static int getScreenHeight(Context context) {
        return ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getHeight();
    }

    public static int getStatusBarHeight(Context context) {
        int n2 = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        return context.getResources().getDimensionPixelSize(n2);
    }

    public static int getNavigationBarHeight(Context context) {
        int n2 = context.getResources().getIdentifier("navigation_bar_height", "dimen", "android");
        return context.getResources().getDimensionPixelSize(n2);
    }

    public static boolean checkDeviceHasNavigationBar(Context object) {
        boolean bl = false;
        int n2 = (object = object.getResources()).getIdentifier("config_showNavigationBar", "bool", "android");
        if (n2 > 0) {
            bl = object.getBoolean(n2);
        }
        try {
            object = Class.forName("android.os.SystemProperties");
            object = (String)object.getMethod("get", String.class).invoke(object, "qemu.hw.mainkeys");
            if ("1".equals(object)) {
                bl = false;
            } else if ("0".equals(object)) {
                bl = true;
            }
        }
        catch (Exception exception) {}
        return bl;
    }
}

