/*
 * Decompiled with CFR 0.152.
 */
package com.shitu.location.epathmap.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import android.os.Looper;
import android.widget.ImageView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Call;
import okhttp3.Response;

public abstract class CallBackUtil<T> {
    public static Handler mMainHandler = new Handler(Looper.getMainLooper());

    public void onProgress(float f2, long l2) {
    }

    public void onError(final Call call, final Exception exception) {
        mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                CallBackUtil.this.onFailure(call, exception);
            }
        });
    }

    public void onSeccess(final Call object, Response response) {
        object = this.onParseResponse((Call)object, response);
        mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                CallBackUtil.this.onResponse(object);
            }
        });
    }

    public abstract T onParseResponse(Call var1, Response var2);

    public abstract void onFailure(Call var1, Exception var2);

    public abstract void onResponse(T var1);

    public static abstract class CallBackFile
    extends CallBackUtil<File> {
        private final String mDestFileDir;
        private final String mdestFileName;

        public CallBackFile(String string2, String string3) {
            this.mDestFileDir = string2;
            this.mdestFileName = string3;
        }

        /*
         * Loose catch block
         */
        @Override
        public File onParseResponse(Call object, Response response) {
            int n2;
            object = null;
            byte[] byArray = new byte[8192];
            FileOutputStream fileOutputStream = null;
            object = response.body().byteStream();
            final long l2 = response.body().contentLength();
            long l3 = 0L;
            File file = new File(this.mDestFileDir);
            if (!file.exists()) {
                file.mkdirs();
            }
            File file2 = new File(file, this.mdestFileName);
            fileOutputStream = new FileOutputStream(file2);
            while ((n2 = ((InputStream)object).read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n2);
                final long l4 = l3 += (long)n2;
                mMainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        this.onProgress((float)l4 * 100.0f / (float)l2, l2);
                    }
                });
            }
            fileOutputStream.flush();
            File file3 = file2;
            try {
                response.body().close();
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
            catch (IOException iOException) {}
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            return file3;
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        response.body().close();
                        if (object != null) {
                            ((InputStream)object).close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    response.body().close();
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }

    public static abstract class CallBackBitmap
    extends CallBackUtil<Bitmap> {
        private int mTargetWidth;
        private int mTargetHeight;

        public CallBackBitmap() {
        }

        public CallBackBitmap(int n2, int n3) {
            this.mTargetWidth = n2;
            this.mTargetHeight = n3;
        }

        public CallBackBitmap(ImageView imageView) {
            int n2 = imageView.getWidth();
            int n3 = imageView.getHeight();
            if (n2 <= 0 || n3 <= 0) {
                throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6ImageView\u7684width\u6216height");
            }
            this.mTargetWidth = n2;
            this.mTargetHeight = n3;
        }

        @Override
        public Bitmap onParseResponse(Call call, Response response) {
            if (this.mTargetWidth == 0 || this.mTargetHeight == 0) {
                return BitmapFactory.decodeStream((InputStream)response.body().byteStream());
            }
            return this.getZoomBitmap(response);
        }

        private Bitmap getZoomBitmap(Response response) {
            byte[] byArray = null;
            try {
                byArray = response.body().bytes();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            response = new BitmapFactory.Options();
            new BitmapFactory.Options().inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)response);
            int n2 = response.outWidth;
            int n3 = response.outHeight;
            int n4 = 1;
            n2 = (int)Math.floor((float)n2 / (float)this.mTargetWidth);
            n3 = (int)Math.floor((float)n3 / (float)this.mTargetHeight);
            if (n2 > 1 || n3 > 1) {
                n4 = Math.max(n2, n3);
            }
            response.inSampleSize = n4;
            response.inJustDecodeBounds = false;
            if ((response = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)response)) == null) {
                throw new RuntimeException("Failed to decode stream.");
            }
            return response;
        }
    }

    public static abstract class CallBackString
    extends CallBackUtil<String> {
        @Override
        public String onParseResponse(Call call, Response response) {
            try {
                return response.body().string();
            }
            catch (IOException iOException) {
                new RuntimeException("failure");
                return "";
            }
        }
    }

    public static abstract class CallBackDefault
    extends CallBackUtil<Response> {
        @Override
        public Response onParseResponse(Call call, Response response) {
            return response;
        }
    }
}

