/*
 * Decompiled with CFR 0.152.
 */
package com.shitu.location.epathmap;

import android.content.Context;
import com.orhanobut.logger.AndroidLogAdapter;
import com.orhanobut.logger.FormatStrategy;
import com.orhanobut.logger.LogAdapter;
import com.orhanobut.logger.Logger;
import com.orhanobut.logger.PrettyFormatStrategy;
import com.parse.Parse;
import com.parse.ParseObject;
import com.parse.ParseQuery;
import com.shitu.location.R;
import com.shitu.location.epathmap.GetCallBack;
import com.shitu.location.epathmap.b;
import com.shitu.location.epathmap.model.bean.DataHolder;
import com.shitu.location.epathmap.model.parse.AndroidLSR;
import com.shitu.location.epathmap.model.parse.App;
import com.shitu.location.epathmap.model.parse.Background;
import com.shitu.location.epathmap.model.parse.BaiduKey;
import com.shitu.location.epathmap.model.parse.BeaconMap;
import com.shitu.location.epathmap.model.parse.District;
import com.shitu.location.epathmap.model.parse.FeedBack;
import com.shitu.location.epathmap.model.parse.IpsUser;
import com.shitu.location.epathmap.model.parse.LocationShare;
import com.shitu.location.epathmap.model.parse.MapData;
import com.shitu.location.epathmap.model.parse.NavigationPhoto;
import com.shitu.location.epathmap.model.parse.POI;
import com.shitu.location.epathmap.model.parse.POIGenre;
import com.shitu.location.epathmap.model.parse.Partner;
import com.shitu.location.epathmap.model.parse.Project;
import com.shitu.location.epathmap.model.parse.Punch;
import com.shitu.location.epathmap.model.parse.Synonym;
import com.shitu.location.epathmap.utils.L;
import com.shitu.location.epathmap.utils.MixpanelEvent;
import com.shitu.location.epathmap.utils.T;
import com.shitu.location.uploadlocation.DaemonEnv;
import com.shitu.location.uploadlocation.impl.TraceServiceImpl;
import com.tencent.bugly.test.crashreport.CrashReport;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EpathLocationSDK {
    protected static final Object monitor = new Object();
    public static Context context;
    private static Configuration configuration;
    public static App app;
    private static String packageNameBD;
    public static String appNameBD;
    public static String appIdBD;
    public static String secretKeyBD;
    public static String apiKeyBD;
    public static boolean hasShareListener;
    public static boolean debug;

    public static void init(Context context, String string2) {
        EpathLocationSDK.init(new Configuration.Builder(context).appKey(string2).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Configuration configuration) {
        Object object = monitor;
        synchronized (object) {
            if (configuration.context == null) {
                throw new RuntimeException("context is null");
            }
            if (configuration.appKey == null) {
                throw new RuntimeException("appKey is null");
            }
            debug = configuration.debug;
            hasShareListener = configuration.hasShareListener;
            context = configuration.context;
            EpathLocationSDK.configuration = configuration;
            EpathLocationSDK.initBugly();
            EpathLocationSDK.initParseServer();
            EpathLocationSDK.initLogger();
            EpathLocationSDK.initMixPanel();
            if (configuration.isOpenBackGroundLocation) {
                EpathLocationSDK.initServer();
            }
            return;
        }
    }

    private static void initServer() {
        DaemonEnv.initialize(context, TraceServiceImpl.class, 1000);
    }

    private static void initMixPanel() {
        MixpanelEvent.init();
    }

    private static void initLogger() {
        Logger.clearLogAdapters();
        PrettyFormatStrategy prettyFormatStrategy = PrettyFormatStrategy.newBuilder().showThreadInfo(false).methodCount(0).tag("21").build();
        Logger.addLogAdapter((LogAdapter)new AndroidLogAdapter((FormatStrategy)prettyFormatStrategy));
    }

    private static void initParseServer() {
        ParseObject.registerSubclass(Project.class);
        ParseObject.registerSubclass(Partner.class);
        ParseObject.registerSubclass(IpsUser.class);
        ParseObject.registerSubclass(NavigationPhoto.class);
        ParseObject.registerSubclass(POI.class);
        ParseObject.registerSubclass(POIGenre.class);
        ParseObject.registerSubclass(FeedBack.class);
        ParseObject.registerSubclass(Background.class);
        ParseObject.registerSubclass(LocationShare.class);
        ParseObject.registerSubclass(BaiduKey.class);
        ParseObject.registerSubclass(AndroidLSR.class);
        ParseObject.registerSubclass(BeaconMap.class);
        ParseObject.registerSubclass(App.class);
        ParseObject.registerSubclass(Punch.class);
        ParseObject.registerSubclass(District.class);
        ParseObject.registerSubclass(Synonym.class);
        Parse.initialize((Parse.Configuration)new Parse.Configuration.Builder(context).applicationId("DYLaL8JDXJetpkZfp3ba").server("https://api.e-path.cn/parse/").build());
        ParseQuery.getQuery(App.class).setCachePolicy(ParseQuery.CachePolicy.CACHE_THEN_NETWORK).getInBackground(configuration.appKey, (app, parseException) -> {
            MixpanelEvent.initSDK();
            if (parseException != null) {
                if (parseException.getCode() == 101) {
                    T.showShort(R.string.ips_location_wrong_app_key);
                }
                parseException.printStackTrace();
                return;
            }
            if (app != null) {
                if (!context.getPackageName().equals(app.getPackageName()) || app.getType() != null && !"Android".equals(app.getType())) {
                    T.showShort(R.string.ips_location_wrong_app_key);
                    return;
                }
                EpathLocationSDK.app = app;
            }
        });
        context.getPackageName();
        ParseQuery.getQuery(BaiduKey.class).whereStartsWith("packageName", context.getPackageName()).setCachePolicy(ParseQuery.CachePolicy.CACHE_ELSE_NETWORK).getFirstInBackground((baiduKey, parseException) -> {
            if (parseException != null) {
                parseException.printStackTrace();
                return;
            }
            if (baiduKey == null) {
                L.e(context.getPackageName(), "no voice permission");
                return;
            }
            packageNameBD = baiduKey.getPackageName();
            appNameBD = baiduKey.getAppName();
            appIdBD = baiduKey.getAppId();
            secretKeyBD = baiduKey.getSecretKey();
            apiKeyBD = baiduKey.getApiKey();
            L.d("baiduKey1---pageNameBD", packageNameBD);
            L.d("baiduKey1---appNameBD", appNameBD);
            L.d("baiduKey1---appIdBD", appIdBD);
            L.d("baiduKey1---secretKeyBD", secretKeyBD);
            L.d("baiduKey1---apiKeyBD", apiKeyBD);
        });
    }

    private static void initBugly() {
        CrashReport.setSdkExtraData(context, "7f6df1cbae", context.getResources().getString(R.string.sdk_version_name));
        CrashReport.initCrashReport(context, "7f6df1cbae", false);
    }

    public static void getMapList(GetCallBack getCallBack) {
        if (EpathLocationSDK.app == null) {
            ParseQuery.getQuery(App.class).setCachePolicy(ParseQuery.CachePolicy.CACHE_THEN_NETWORK).whereEqualTo("pkgName", (Object)context.getPackageName()).whereEqualTo("type", (Object)"Android").getInBackground(configuration.appKey, (app, parseException) -> {
                MixpanelEvent.initSDK();
                if (parseException != null) {
                    if (parseException.getCode() == 101) {
                        T.showShort(R.string.ips_location_wrong_app_key);
                    }
                    parseException.printStackTrace();
                    getCallBack.onError((Exception)parseException);
                    return;
                }
                if (!app.getPackageName().equals(context.getPackageName()) || !app.getType().equals("Android")) {
                    T.showShort(R.string.ips_location_wrong_app_key);
                    getCallBack.onError(new Exception(context.getString(R.string.ips_location_wrong_app_key)));
                    return;
                }
                EpathLocationSDK.app = app;
                EpathLocationSDK.getProjects(getCallBack);
            });
            return;
        }
        EpathLocationSDK.getProjects(getCallBack);
    }

    private static void getProjects(GetCallBack getCallBack) {
        ParseQuery parseQuery = app.getProjects().getQuery();
        parseQuery.whereEqualTo("visible", (Object)true);
        parseQuery.orderByAscending("order");
        parseQuery.include("district");
        parseQuery.setCachePolicy(ParseQuery.CachePolicy.CACHE_THEN_NETWORK);
        if (!debug) {
            parseQuery.whereEqualTo("isDebug", (Object)false);
        }
        parseQuery.findInBackground((object, object2) -> {
            if (object2 != null) {
                object2.printStackTrace();
                if (object2.getCode() != 120) {
                    getCallBack.onError((Exception)object2);
                }
                return;
            }
            try {
                object2 = new JSONArray();
                ArrayList<MapData> arrayList = new ArrayList<MapData>();
                object = object.iterator();
                while (object.hasNext()) {
                    Project project = (Project)((Object)((Object)object.next()));
                    Object object3 = new JSONObject();
                    object3.put("objectId", (Object)project.getObjectId());
                    object3.put("name", (Object)project.getName());
                    object3.put("picture", (Object)project.getPicture());
                    object3.put("buildingId", (Object)project.getBuildingId());
                    object3.put("token", (Object)project.getToken());
                    object3.put("floorNumber", project.getFloorNumber());
                    object3.put("floorName", (Object)project.getFloorName());
                    object3.put("zoom", project.getZoom());
                    object3.put("angle", project.getAngle());
                    object3.put("powerThreshold", project.getPowerThreshold());
                    object3.put("inToOut", project.getInToOut());
                    object3.put("outToIn", project.getOutToIn());
                    object3.put("gpsFloorlayer", project.getGpsFloorlayer());
                    object3.put("navigationZoom", project.getNavigationZoom());
                    if (project.getCenterPoint() != null) {
                        object3.put("lat", project.getCenterPoint().getLatitude());
                        object3.put("lng", project.getCenterPoint().getLongitude());
                    }
                    if (project.getDistrict() != null) {
                        object3.put("districtName", (Object)project.getDistrict().getString("name"));
                    }
                    object2.put(object3);
                    object3 = new MapData();
                    ((MapData)object3).setObjectId(project.getObjectId());
                    ((MapData)object3).setName(project.getName());
                    ((MapData)object3).setPicture(project.getPicture());
                    ((MapData)object3).setBuildingId(project.getBuildingId());
                    ((MapData)object3).setToken(project.getToken());
                    ((MapData)object3).setFloorNumber(project.getFloorNumber());
                    ((MapData)object3).setFloorName(project.getFloorName());
                    ((MapData)object3).setZoom(project.getZoom());
                    ((MapData)object3).setAngle((float)project.getAngle());
                    ((MapData)object3).setPowerThreshold(project.getPowerThreshold());
                    ((MapData)object3).setInToOut(project.getInToOut());
                    ((MapData)object3).setOutToIn(project.getOutToIn());
                    ((MapData)object3).setGpsFloorlayer(project.getGpsFloorlayer());
                    ((MapData)object3).setNavigationZoom(project.getNavigationZoom());
                    ((MapData)object3).setTitle(project.getTitle());
                    if (project.getCenterPoint() != null) {
                        ((MapData)object3).setLat(project.getCenterPoint().getLatitude());
                        ((MapData)object3).setLng(project.getCenterPoint().getLongitude());
                    }
                    if (project.getDistrict() != null) {
                        ((MapData)object3).setDistrictName(project.getDistrict().getString("name"));
                    }
                    arrayList.add((MapData)object3);
                }
                DataHolder.getInstance().setMapDataList(arrayList);
                getCallBack.onSuccess(object2.toString());
                return;
            }
            catch (JSONException jSONException) {
                object2 = jSONException;
                jSONException.printStackTrace();
                getCallBack.onError((Exception)object2);
                return;
            }
        });
    }

    public static class Configuration {
        private Context context;
        private String appKey;
        private boolean debug;
        private boolean hasShareListener;
        private boolean isOpenBackGroundLocation = false;

        private Configuration(Builder builder) {
            this.context = builder.context;
            this.appKey = builder.appKey;
            this.debug = builder.debug;
            this.hasShareListener = builder.hasShareListener;
            this.isOpenBackGroundLocation = builder.isOpenBackGroundLocation;
        }

        /* synthetic */ Configuration(Builder builder, b b2) {
            this(builder);
        }

        public static final class Builder {
            private Context context;
            private String appKey;
            private boolean debug;
            private boolean hasShareListener;
            private boolean isOpenBackGroundLocation = false;

            public final Builder appKey(String string2) {
                this.appKey = string2;
                return this;
            }

            public final Builder debug(boolean bl) {
                this.debug = bl;
                L.setIsDebug(bl);
                return this;
            }

            public final Builder hasShareListener(boolean bl) {
                this.hasShareListener = bl;
                return this;
            }

            public final Builder openBackGroundLocationServerce(boolean bl) {
                this.isOpenBackGroundLocation = bl;
                return this;
            }

            public Builder(Context context) {
                this.context = context;
            }

            public final Configuration build() {
                return new Configuration(this, null);
            }
        }
    }
}

