/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine;

import android.graphics.Point;
import com.sails.engine.MapView;
import com.sails.engine.Projection;
import com.sails.engine.core.model.GeoPoint;
import com.sails.engine.core.model.MapPosition;
import com.sails.engine.core.util.MercatorProjection;

class p
implements Projection {
    private static final String a = "invalid MapView dimensions";
    private final MapView b;

    p(MapView mapView) {
        this.b = mapView;
    }

    @Override
    public GeoPoint fromPixels(int n2, int n3) {
        if (this.b.getWidth() <= 0 || this.b.getHeight() <= 0) {
            return null;
        }
        MapPosition mapPosition = this.b.getMapViewPosition().getMapPosition();
        GeoPoint geoPoint = mapPosition.geoPoint;
        double d2 = MercatorProjection.longitudeToPixelX(geoPoint.longitude, mapPosition.zoomLevel);
        double d3 = MercatorProjection.latitudeToPixelY(geoPoint.latitude, mapPosition.zoomLevel);
        d2 -= (double)(this.b.getWidth() >> 1);
        d3 -= (double)(this.b.getHeight() >> 1);
        geoPoint = new GeoPoint(0.0, 0.0);
        try {
            geoPoint = new GeoPoint(MercatorProjection.pixelYToLatitude(d3 + (double)n3, mapPosition.zoomLevel), MercatorProjection.pixelXToLongitude(d2 + (double)n2, mapPosition.zoomLevel));
        }
        catch (Exception exception) {}
        return geoPoint;
    }

    @Override
    public double getLatitudeSpan() {
        if (this.b.getWidth() > 0 && this.b.getHeight() > 0) {
            GeoPoint geoPoint = this.fromPixels(0, 0);
            GeoPoint geoPoint2 = this.fromPixels(0, this.b.getHeight());
            return Math.abs(geoPoint.latitude - geoPoint2.latitude);
        }
        throw new IllegalStateException(a);
    }

    @Override
    public double getLongitudeSpan() {
        if (this.b.getWidth() > 0 && this.b.getHeight() > 0) {
            GeoPoint geoPoint = this.fromPixels(0, 0);
            GeoPoint geoPoint2 = this.fromPixels(this.b.getWidth(), 0);
            return Math.abs(geoPoint.longitude - geoPoint2.longitude);
        }
        throw new IllegalStateException(a);
    }

    @Override
    public float metersToPixels(float f2, float f3) {
        double d2 = MercatorProjection.calculateGroundResolution(this.b.getMapViewPosition().getCenter().latitude, f3);
        return (float)((double)f2 * (1.0 / d2));
    }

    @Override
    public Point toPixels(GeoPoint geoPoint, Point point) {
        if (this.b.getWidth() <= 0 || this.b.getHeight() <= 0) {
            return null;
        }
        MapPosition mapPosition = this.b.getMapViewPosition().getMapPosition();
        GeoPoint geoPoint2 = mapPosition.geoPoint;
        double d2 = MercatorProjection.longitudeToPixelX(geoPoint2.longitude, mapPosition.zoomLevel);
        double d3 = MercatorProjection.latitudeToPixelY(geoPoint2.latitude, mapPosition.zoomLevel);
        d2 -= (double)(this.b.getWidth() >> 1);
        d3 -= (double)(this.b.getHeight() >> 1);
        if (point == null) {
            return new Point((int)(MercatorProjection.longitudeToPixelX(geoPoint.longitude, mapPosition.zoomLevel) - d2), (int)(MercatorProjection.latitudeToPixelY(geoPoint.latitude, mapPosition.zoomLevel) - d3));
        }
        point.x = (int)(MercatorProjection.longitudeToPixelX(geoPoint.longitude, mapPosition.zoomLevel) - d2);
        point.y = (int)(MercatorProjection.latitudeToPixelY(geoPoint.latitude, mapPosition.zoomLevel) - d3);
        return point;
    }

    @Override
    public Point toPoint(GeoPoint geoPoint, Point point, float f2) {
        if (point == null) {
            return new Point((int)MercatorProjection.longitudeToPixelX(geoPoint.longitude, f2), (int)MercatorProjection.latitudeToPixelY(geoPoint.latitude, f2));
        }
        point.x = (int)MercatorProjection.longitudeToPixelX(geoPoint.longitude, f2);
        point.y = (int)MercatorProjection.latitudeToPixelY(geoPoint.latitude, f2);
        return point;
    }
}

