/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine.overlay;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import com.sails.engine.core.model.BoundingBox;
import com.sails.engine.core.model.GeoPoint;
import com.sails.engine.core.model.Point;
import com.sails.engine.core.util.MercatorProjection;
import com.sails.engine.overlay.OverlayItem;
import com.sails.engine.overlay.ScreenDensity;
import java.util.List;

public class TextOverlay
implements OverlayItem {
    private boolean a = false;
    private boolean b = true;
    private GeoPoint c;
    private Paint d;
    private Paint e;
    private float f;
    private String g;
    private Rect h = new Rect();
    private Rect i = new Rect();
    private String[] j;
    private double k = 5.0;
    public List<TextOverlay> textOverlayList = null;

    private static void a(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("radius must not be negative: " + f2);
        }
    }

    private static double a(double d2, float f2, float f3) {
        double d3 = MercatorProjection.calculateGroundResolution(d2, f3);
        return (double)f2 / d3;
    }

    public TextOverlay(GeoPoint geoPoint, String string, Paint paint, Paint paint2) {
        this.c = geoPoint;
        this.g = string;
        this.d = paint;
        this.e = paint2;
    }

    private static boolean a(Canvas canvas, float f2, float f3, float f4, float f5) {
        return f4 >= 0.0f && f2 <= (float)canvas.getWidth() && f5 >= 0.0f && f3 <= (float)canvas.getHeight();
    }

    @Override
    public synchronized boolean draw(BoundingBox boundingBox, float f2, Canvas canvas, Point point, int n2, int n3, float f3) {
        if (this.c == null || this.e == null && this.d == null) {
            return false;
        }
        double d2 = this.c.latitude;
        float f4 = (float)(MercatorProjection.longitudeToPixelX(this.c.longitude, f2) - point.x);
        f2 = (float)(MercatorProjection.latitudeToPixelY(d2, f2) - point.y);
        double d3 = (f4 - (float)n2) * ScreenDensity.density;
        double d4 = (f2 - (float)n3) * ScreenDensity.density;
        double d5 = d3 * Math.cos((double)(-f3) / 180.0 * Math.PI) + d4 * Math.sin((double)(-f3) / 180.0 * Math.PI);
        double d6 = d4 * Math.cos((double)(-f3) / 180.0 * Math.PI) - d3 * Math.sin((double)(-f3) / 180.0 * Math.PI);
        double d7 = (double)n2 + d5;
        double d8 = (double)n3 + d6;
        f4 = (int)d7;
        f2 = (int)d8;
        if (this.b) {
            int n4;
            this.j = this.g.split(" - ");
            Object object = "";
            for (n4 = 0; n4 < this.j.length; ++n4) {
                if (this.j[n4].length() <= ((String)object).length()) continue;
                object = this.j[n4];
            }
            if (this.e != null) {
                this.e.getTextBounds((String)object, 0, ((String)object).length(), this.i);
            } else if (this.d != null) {
                this.d.getTextBounds((String)object, 0, ((String)object).length(), this.i);
            }
            n4 = this.i.height();
            this.i.bottom = (int)((double)this.i.bottom + ((double)n4 + this.k / 2.0) * (double)this.j.length / 2.0);
            this.i.top = (int)((double)this.i.top - ((double)n4 + this.k / 2.0) * (double)this.j.length / 2.0);
            this.i.right += 20;
            this.b = false;
        }
        this.h = new Rect(this.i);
        this.h.offset((int)f4 - this.i.width() / 2, (int)(f2 + (float)(this.i.height() / 2)));
        if (!TextOverlay.a(canvas, this.h.left, this.h.top, this.h.right, this.h.bottom)) {
            return false;
        }
        this.a = true;
        if (this.textOverlayList != null) {
            for (TextOverlay textOverlay : this.textOverlayList) {
                if (!new Rect(this.h).intersect(textOverlay.h)) continue;
                this.a = false;
                break;
            }
        }
        if (this.a) {
            double d9;
            if (this.e != null) {
                double d10 = (double)(this.j.length - 1) * ((double)(this.e.descent() - this.e.ascent()) + this.k) / 2.0;
                d9 = (double)(f2 - (this.e.descent() + this.e.ascent()) / 2.0f) - d10 / 2.0;
                for (int i2 = 0; i2 < this.j.length; ++i2) {
                    canvas.drawText(this.j[i2], f4, (float)(d9 + (double)i2 * ((double)(this.e.descent() - this.e.ascent()) + this.k)), this.e);
                }
            }
            if (this.d != null) {
                double d11 = (double)(this.j.length - 1) * ((double)(this.d.descent() - this.d.ascent()) + this.k) / 2.0;
                d9 = (double)(f2 - (this.d.descent() + this.d.ascent()) / 2.0f) - d11 / 2.0;
                for (int i3 = 0; i3 < this.j.length; ++i3) {
                    canvas.drawText(this.j[i3], f4, (float)(d9 + (double)i3 * ((double)(this.d.descent() - this.d.ascent()) + this.k)), this.d);
                }
            }
        }
        return true;
    }

    public synchronized GeoPoint getGeoPoint() {
        return this.c;
    }

    public synchronized Paint getPaintFill() {
        return this.d;
    }

    public synchronized Paint getPaintStroke() {
        return this.e;
    }

    public synchronized float getRadius() {
        return this.f;
    }

    public synchronized void setGeoPoint(GeoPoint geoPoint) {
        this.c = geoPoint;
    }

    public synchronized void setPaintFill(Paint paint) {
        this.d = paint;
    }

    public synchronized void setPaintStroke(Paint paint) {
        this.e = paint;
    }

    public synchronized void setText(String string) {
        this.g = string;
        this.b = true;
    }

    public boolean isDrawed() {
        return this.a;
    }
}

