/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine.overlay;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.sails.engine.core.model.BoundingBox;
import com.sails.engine.core.model.GeoPoint;
import com.sails.engine.core.model.Point;
import com.sails.engine.core.util.MercatorProjection;
import com.sails.engine.overlay.OverlayItem;
import com.sails.engine.overlay.ScreenDensity;

public class SingleLine
implements OverlayItem {
    private Paint a;
    private GeoPoint b;
    private GeoPoint c;

    public SingleLine(GeoPoint geoPoint, GeoPoint geoPoint2, Paint paint) {
        this.b = geoPoint;
        this.c = geoPoint2;
        this.a = paint;
    }

    protected int[] a(float f2, float f3, int n2, int n3, float f4) {
        int[] nArray = new int[2];
        double d2 = (f2 - (float)n2) * ScreenDensity.density;
        double d3 = (f3 - (float)n3) * ScreenDensity.density;
        double d4 = d2 * Math.cos((double)f4 / 180.0 * Math.PI) + d3 * Math.sin((double)(-f4) / 180.0 * Math.PI);
        double d5 = d3 * Math.cos((double)f4 / 180.0 * Math.PI) - d2 * Math.sin((double)(-f4) / 180.0 * Math.PI);
        double d6 = (double)n2 + d4;
        double d7 = (double)n3 + d5;
        nArray[0] = (int)d6;
        nArray[1] = (int)d7;
        return nArray;
    }

    @Override
    public synchronized boolean draw(BoundingBox boundingBox, float f2, Canvas canvas, Point point, int n2, int n3, float f3) {
        if (this.b == null || this.c == null || this.a == null) {
            return false;
        }
        double d2 = this.b.latitude;
        float f4 = (float)(MercatorProjection.longitudeToPixelX(this.b.longitude, f2) - point.x);
        float f5 = (float)(MercatorProjection.latitudeToPixelY(d2, f2) - point.y);
        int[] nArray = this.a(f4, f5, n2, n3, f3);
        double d3 = this.c.latitude;
        f4 = (float)(MercatorProjection.longitudeToPixelX(this.c.longitude, f2) - point.x);
        float f6 = (float)(MercatorProjection.latitudeToPixelY(d3, f2) - point.y);
        int[] nArray2 = this.a(f4, f6, n2, n3, f3);
        canvas.drawLine((float)nArray[0], (float)nArray[1], (float)nArray2[0], (float)nArray2[1], this.a);
        return true;
    }

    public synchronized Paint getPaintStroke() {
        return this.a;
    }

    public synchronized GeoPoint getStart() {
        return this.b;
    }

    public synchronized GeoPoint getEnd() {
        return this.c;
    }

    public synchronized void setPaintStroke(Paint paint) {
        this.a = paint;
    }

    public synchronized void setStartEnd(GeoPoint geoPoint, GeoPoint geoPoint2) {
        this.b = geoPoint;
        this.c = geoPoint2;
    }
}

