/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine.overlay;

import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import com.sails.engine.core.model.BoundingBox;
import com.sails.engine.core.model.GeoPoint;
import com.sails.engine.core.model.Point;
import com.sails.engine.core.util.MercatorProjection;
import com.sails.engine.overlay.OverlayItem;
import com.sails.engine.overlay.PolygonalChain;
import com.sails.engine.overlay.ScreenDensity;
import java.util.ArrayList;

public class PolylineWithSmallArrow
implements OverlayItem {
    private int b;
    private Paint c;
    private PolygonalChain d;
    public static double DegreeTolerance = 0.0;
    int a;
    public double distanceTolerance = 5.0;

    public PolylineWithSmallArrow(PolygonalChain polygonalChain, Paint paint, int n2, int n3) {
        this.a = n3;
        this.a(polygonalChain, paint, n2);
    }

    public PolylineWithSmallArrow(PolygonalChain polygonalChain, Paint paint, int n2) {
        this.a = -1;
        this.a(polygonalChain, paint, n2);
    }

    private void a(PolygonalChain polygonalChain, Paint paint, int n2) {
        this.d = polygonalChain;
        this.c = paint;
        this.b = n2;
        this.distanceTolerance = (double)this.b * 1.5 * (double)ScreenDensity.density;
    }

    @Override
    public synchronized boolean draw(BoundingBox boundingBox, float f2, Canvas canvas, Point point, int n2, int n3, float f3) {
        if (this.d == null || this.c == null) {
            return false;
        }
        boundingBox = this.d.a(f2, point, false, n2, n3, f3);
        if (boundingBox == null) {
            return false;
        }
        Paint paint = new Paint(this.c);
        paint.setPathEffect((PathEffect)new CornerPathEffect(15.0f));
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawPath((Path)boundingBox, paint);
        this.a(f2, canvas, point, n2, n3, f3);
        return true;
    }

    private void a(float f2, Canvas canvas, Point point, int n2, int n3, float f3) {
        int n4 = this.d.getGeoPoints().size();
        if (n4 < 2) {
            return;
        }
        ArrayList<PixelNode> arrayList = new ArrayList<PixelNode>();
        double d2 = 0.0;
        Object object = null;
        for (int i2 = 0; i2 < n4; ++i2) {
            Object object2 = this.d.getGeoPoints().get(i2);
            double d3 = ((GeoPoint)object2).latitude;
            float f4 = (float)(MercatorProjection.longitudeToPixelX(((GeoPoint)object2).longitude, f2) - point.x);
            float f5 = (float)(MercatorProjection.latitudeToPixelY(d3, f2) - point.y);
            double d4 = (f4 - (float)n2) * ScreenDensity.density;
            double d5 = (f5 - (float)n3) * ScreenDensity.density;
            double d6 = d4 * Math.cos((double)(-f3) / 180.0 * Math.PI) + d5 * Math.sin((double)(-f3) / 180.0 * Math.PI);
            double d7 = d5 * Math.cos((double)(-f3) / 180.0 * Math.PI) - d4 * Math.sin((double)(-f3) / 180.0 * Math.PI);
            double d8 = (double)n2 + d6;
            double d9 = (double)n3 + d7;
            object2 = new PixelNode(d8, d9, 0.0);
            if (i2 != 0) {
                ((PixelNode)object).c = Math.atan2(((PixelNode)object2).b - ((PixelNode)object).b, ((PixelNode)object2).a - ((PixelNode)object).a);
                int n5 = 0;
                while ((double)n5 < 500.0) {
                    if (d2 > this.distanceTolerance) {
                        arrayList.add(new PixelNode(((PixelNode)object).a + (((PixelNode)object2).a - ((PixelNode)object).a) * (double)n5 / 500.0, ((PixelNode)object).b + (((PixelNode)object2).b - ((PixelNode)object).b) * (double)n5 / 500.0, Math.atan2(((PixelNode)object2).b - ((PixelNode)object).b, ((PixelNode)object2).a - ((PixelNode)object).a)));
                        d2 = 0.0;
                    }
                    d2 += Math.pow(Math.pow((((PixelNode)object2).b - ((PixelNode)object).b) / 500.0, 2.0) + Math.pow((((PixelNode)object2).a - ((PixelNode)object).a) / 500.0, 2.0), 0.5);
                    ++n5;
                }
            }
            object = object2;
        }
        double d10 = 0.23566666666666666 * (double)this.b * (double)ScreenDensity.density;
        Paint paint = new Paint(this.c);
        paint.setColor(this.a);
        paint.setStrokeWidth(3.0f);
        paint.setStyle(Paint.Style.STROKE);
        if (arrayList.size() > 0) {
            for (PixelNode pixelNode : arrayList) {
                point = new Path();
                point.setFillType(Path.FillType.EVEN_ODD);
                point.moveTo((float)(d10 * Math.cos(pixelNode.c + 1.0471975511965976) + pixelNode.a), (float)(d10 * Math.sin(pixelNode.c + 1.0471975511965976) + pixelNode.b));
                point.lineTo((float)(1.5 * d10 * Math.cos(pixelNode.c) + pixelNode.a), (float)(1.5 * d10 * Math.sin(pixelNode.c) + pixelNode.b));
                point.lineTo((float)(d10 * Math.cos(pixelNode.c - 1.0471975511965976) + pixelNode.a), (float)(d10 * Math.sin(pixelNode.c - 1.0471975511965976) + pixelNode.b));
                canvas.drawPath((Path)point, paint);
            }
        }
    }

    public synchronized Paint getPaintStroke() {
        return this.c;
    }

    public synchronized PolygonalChain getPolygonalChain() {
        return this.d;
    }

    public synchronized void setPaintStroke(Paint paint) {
        this.c = paint;
    }

    public synchronized void setPolygonalChain(PolygonalChain polygonalChain) {
        this.d = polygonalChain;
    }

    static class PixelNode {
        double a;
        double b;
        double c;

        PixelNode(double d2, double d3, double d4) {
            this.a = d2;
            this.b = d3;
            this.c = d4;
        }
    }
}

