/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine.overlay;

import android.graphics.Canvas;
import android.graphics.Path;
import com.sails.engine.core.model.GeoPoint;
import com.sails.engine.core.model.Point;
import com.sails.engine.core.util.MercatorProjection;
import com.sails.engine.overlay.ScreenDensity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PolygonalChain {
    private final List<GeoPoint> a;

    public PolygonalChain(Collection<GeoPoint> collection) {
        if (collection == null) {
            this.a = Collections.synchronizedList(new ArrayList());
            return;
        }
        this.a = Collections.synchronizedList(new ArrayList<GeoPoint>(collection));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GeoPoint> getGeoPoints() {
        List<GeoPoint> list = this.a;
        synchronized (list) {
            return this.a;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        List<GeoPoint> list = this.a;
        synchronized (list) {
            int n2 = this.a.size();
            if (n2 < 2) {
                return false;
            }
            GeoPoint geoPoint = this.a.get(0);
            GeoPoint geoPoint2 = this.a.get(n2 - 1);
            return geoPoint.equals(geoPoint2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Path a(float f2, Point point, boolean bl, int n2, int n3, float f3) {
        List<GeoPoint> list = this.a;
        synchronized (list) {
            int n4 = this.a.size();
            if (n4 < 2) {
                return null;
            }
            Path path = new Path();
            for (int i2 = 0; i2 < n4; ++i2) {
                GeoPoint geoPoint = this.a.get(i2);
                double d2 = geoPoint.latitude;
                float f4 = (float)(MercatorProjection.longitudeToPixelX(geoPoint.longitude, f2) - point.x);
                float f5 = (float)(MercatorProjection.latitudeToPixelY(d2, f2) - point.y);
                double d3 = (f4 - (float)n2) * ScreenDensity.density;
                double d4 = (f5 - (float)n3) * ScreenDensity.density;
                double d5 = d3 * Math.cos((double)(-f3) / 180.0 * Math.PI) + d4 * Math.sin((double)(-f3) / 180.0 * Math.PI);
                double d6 = d4 * Math.cos((double)(-f3) / 180.0 * Math.PI) - d3 * Math.sin((double)(-f3) / 180.0 * Math.PI);
                double d7 = (double)n2 + d5;
                double d8 = (double)n3 + d6;
                f4 = (int)d7;
                f5 = (int)d8;
                if (i2 == 0) {
                    path.moveTo(f4, f5);
                    continue;
                }
                path.lineTo(f4, f5);
            }
            if (bl && !this.isClosed()) {
                path.close();
            }
            return path;
        }
    }

    private static boolean a(Canvas canvas, double d2, double d3, double d4, double d5) {
        return d4 >= 0.0 && d2 <= (double)canvas.getWidth() && d5 >= 0.0 && d3 <= (double)canvas.getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Path a(Canvas canvas, float f2, Point point, boolean bl, int n2, int n3, float f3) {
        List<GeoPoint> list = this.a;
        synchronized (list) {
            int n4 = this.a.size();
            if (n4 < 2) {
                return null;
            }
            Path path = new Path();
            boolean bl2 = true;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            for (int i2 = 0; i2 < n4; ++i2) {
                GeoPoint geoPoint = this.a.get(i2);
                double d6 = geoPoint.latitude;
                float f4 = (float)(MercatorProjection.longitudeToPixelX(geoPoint.longitude, f2) - point.x);
                float f5 = (float)(MercatorProjection.latitudeToPixelY(d6, f2) - point.y);
                double d7 = (f4 - (float)n2) * ScreenDensity.density;
                double d8 = (f5 - (float)n3) * ScreenDensity.density;
                double d9 = d7 * Math.cos((double)(-f3) / 180.0 * Math.PI) + d8 * Math.sin((double)(-f3) / 180.0 * Math.PI);
                double d10 = d8 * Math.cos((double)(-f3) / 180.0 * Math.PI) - d7 * Math.sin((double)(-f3) / 180.0 * Math.PI);
                double d11 = (double)n2 + d9;
                double d12 = (double)n3 + d10;
                f4 = (int)d11;
                f5 = (int)d12;
                if (bl2) {
                    bl2 = false;
                    d2 = d11;
                    d4 = d11;
                    d3 = d12;
                    d5 = d12;
                } else {
                    if (d11 < d2) {
                        d2 = d11;
                    }
                    if (d11 > d4) {
                        d4 = d11;
                    }
                    if (d12 < d3) {
                        d3 = d12;
                    }
                    if (d12 > d5) {
                        d5 = d12;
                    }
                }
                if (i2 == 0) {
                    path.moveTo(f4, f5);
                    continue;
                }
                path.lineTo(f4, f5);
            }
            if (!PolygonalChain.a(canvas, d2, d3, d4 - d2, d5 - d3)) {
                return null;
            }
            if (bl && !this.isClosed()) {
                path.close();
            }
            return path;
        }
    }
}

