/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine.overlay;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import com.sails.engine.core.model.BoundingBox;
import com.sails.engine.core.model.GeoPoint;
import com.sails.engine.core.model.Point;
import com.sails.engine.core.util.MercatorProjection;
import com.sails.engine.overlay.OverlayItem;
import com.sails.engine.overlay.ScreenDensity;

public class OrientationMarker
implements OverlayItem {
    private float a;
    public GeoPoint geoPoint;
    private Bitmap b = null;
    private final Paint c;
    private Rect d = new Rect();

    public OrientationMarker(GeoPoint geoPoint, Bitmap bitmap) {
        this.geoPoint = geoPoint;
        this.b = bitmap;
        this.c = new Paint(1);
        this.c.setFilterBitmap(true);
    }

    public void setTransparency(int n2) {
        this.c.setAlpha(n2);
    }

    public void setBitmap(Bitmap bitmap) {
        this.b = bitmap;
    }

    @Override
    public boolean draw(BoundingBox boundingBox, float f2, Canvas canvas, Point point, int n2, int n3, float f3) {
        if (this.b == null) {
            return true;
        }
        int n4 = (int)(MercatorProjection.longitudeToPixelX(this.geoPoint.longitude, f2) - point.x);
        int n5 = (int)(MercatorProjection.latitudeToPixelY(this.geoPoint.latitude, f2) - point.y);
        double d2 = (float)(n4 - n2) * ScreenDensity.density;
        double d3 = (float)(n5 - n3) * ScreenDensity.density;
        double d4 = d2 * Math.cos((double)(-f3) / 180.0 * Math.PI) + d3 * Math.sin((double)(-f3) / 180.0 * Math.PI);
        double d5 = d3 * Math.cos((double)(-f3) / 180.0 * Math.PI) - d2 * Math.sin((double)(-f3) / 180.0 * Math.PI);
        double d6 = (double)n2 + d4;
        double d7 = (double)n3 + d5;
        n4 = (int)d6;
        n5 = (int)d7;
        this.d.left = (int)d4 - this.b.getWidth() / 2;
        this.d.top = (int)d5 - this.b.getHeight() / 2;
        this.d.right = (int)d4 + this.b.getWidth() / 2;
        this.d.bottom = (int)d5 + this.b.getHeight() / 2;
        if (n4 + this.b.getWidth() > 0 && n4 - this.b.getWidth() / 2 < canvas.getWidth() && n5 + this.b.getHeight() > 0 && n5 - this.b.getHeight() / 2 < canvas.getHeight()) {
            point = new Matrix();
            point.setRotate(this.a + f3, this.b.getWidth() / 2, this.b.getHeight() / 2);
            point.postTranslate(n4 - this.b.getWidth() / 2, n5 - this.b.getHeight() / 2);
            canvas.drawBitmap(this.b, (Matrix)point, this.c);
        }
        return true;
    }

    public boolean isInMarker(int n2, int n3) {
        return n2 > this.d.left && n2 < this.d.right && n3 > this.d.top && n3 < this.d.bottom;
    }

    public void setRotation(float f2) {
        this.a = f2;
    }

    public float getRotation() {
        return this.a;
    }

    public synchronized void setGeoPoint(GeoPoint geoPoint) {
        this.geoPoint = geoPoint;
    }

    public synchronized GeoPoint getGeoPoint() {
        return this.geoPoint;
    }
}

