/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine.overlay;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import com.sails.engine.core.model.BoundingBox;
import com.sails.engine.core.model.GeoPoint;
import com.sails.engine.core.model.Point;
import com.sails.engine.core.util.MercatorProjection;
import com.sails.engine.overlay.OverlayItem;
import com.sails.engine.overlay.ScreenDensity;

public class Marker
implements OverlayItem {
    private Drawable a;
    private GeoPoint b;
    private Rect c = new Rect();
    private int d = 255;

    public static Drawable boundCenter(Drawable drawable) {
        int n2 = drawable.getIntrinsicWidth();
        int n3 = drawable.getIntrinsicHeight();
        drawable.setBounds(n2 / -2, n3 / -2, n2 / 2, n3 / 2);
        return drawable;
    }

    public static Drawable boundCenterBottom(Drawable drawable) {
        int n2 = drawable.getIntrinsicWidth();
        int n3 = drawable.getIntrinsicHeight();
        drawable.setBounds(n2 / -2, -n3, n2 / 2, 0);
        return drawable;
    }

    private static boolean a(Canvas canvas, float f2, float f3, float f4, float f5) {
        return f4 >= 0.0f && f2 <= (float)canvas.getWidth() && f5 >= 0.0f && f3 <= (float)canvas.getHeight();
    }

    public void setTransparency(int n2) {
        this.d = n2;
    }

    public Marker(GeoPoint geoPoint, Drawable drawable) {
        this.b = geoPoint;
        this.a = drawable;
    }

    @Override
    public synchronized boolean draw(BoundingBox boundingBox, float f2, Canvas canvas, Point point, int n2, int n3, float f3) {
        if (this.b == null || this.a == null) {
            return false;
        }
        double d2 = this.b.latitude;
        int n4 = (int)(MercatorProjection.longitudeToPixelX(this.b.longitude, f2) - point.x);
        int n5 = (int)(MercatorProjection.latitudeToPixelY(d2, f2) - point.y);
        double d3 = (float)(n4 - n2) * ScreenDensity.density;
        double d4 = (float)(n5 - n3) * ScreenDensity.density;
        double d5 = d3 * Math.cos((double)(-f3) / 180.0 * Math.PI) + d4 * Math.sin((double)(-f3) / 180.0 * Math.PI);
        double d6 = d4 * Math.cos((double)(-f3) / 180.0 * Math.PI) - d3 * Math.sin((double)(-f3) / 180.0 * Math.PI);
        double d7 = (double)n2 + d5;
        double d8 = (double)n3 + d6;
        n4 = (int)d7;
        n5 = (int)d8;
        point = this.a.copyBounds();
        n2 = n4 + ((Rect)point).left;
        n3 = n5 + ((Rect)point).top;
        this.c.left = (int)d5 + ((Rect)point).left;
        this.c.top = (int)d6 + ((Rect)point).top;
        this.c.right = (int)d5 + ((Rect)point).right;
        this.c.bottom = (int)d6 + ((Rect)point).bottom;
        if (!Marker.a(canvas, n2, n3, n4 += ((Rect)point).right, n5 += ((Rect)point).bottom)) {
            return false;
        }
        this.a.setAlpha(this.d);
        this.a.setBounds(n2, n3, n4, n5);
        this.a.draw(canvas);
        this.a.setBounds((Rect)point);
        return true;
    }

    public boolean isInMarker(int n2, int n3) {
        return n2 > this.c.left && n2 < this.c.right && n3 > this.c.top && n3 < this.c.bottom;
    }

    public synchronized Drawable getDrawable() {
        return this.a;
    }

    public synchronized GeoPoint getGeoPoint() {
        return this.b;
    }

    public synchronized void setDrawable(Drawable drawable) {
        this.a = drawable;
    }

    public synchronized void setGeoPoint(GeoPoint geoPoint) {
        this.b = geoPoint;
    }
}

