/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine.overlay;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.sails.engine.core.model.BoundingBox;
import com.sails.engine.core.model.GeoPoint;
import com.sails.engine.core.model.Point;
import com.sails.engine.core.util.MercatorProjection;
import com.sails.engine.overlay.OverlayItem;
import com.sails.engine.overlay.ScreenDensity;

public class Circle
implements OverlayItem {
    private GeoPoint a;
    private Paint b;
    private Paint c;
    private float d;

    private static void a(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("radius must not be negative: " + f2);
        }
    }

    private static double a(double d2, float f2, float f3) {
        double d3 = MercatorProjection.calculateGroundResolution(d2, f3);
        return (double)f2 / d3;
    }

    public Circle(GeoPoint geoPoint, float f2, Paint paint, Paint paint2) {
        Circle.a(f2);
        this.a = geoPoint;
        this.d = f2;
        this.b = paint;
        this.c = paint2;
    }

    @Override
    public synchronized boolean draw(BoundingBox boundingBox, float f2, Canvas canvas, Point point, int n2, int n3, float f3) {
        if (this.a == null || this.c == null && this.b == null) {
            return false;
        }
        double d2 = this.a.latitude;
        float f4 = (float)(MercatorProjection.longitudeToPixelX(this.a.longitude, f2) - point.x);
        float f5 = (float)(MercatorProjection.latitudeToPixelY(d2, f2) - point.y);
        double d3 = (f4 - (float)n2) * ScreenDensity.density;
        double d4 = (f5 - (float)n3) * ScreenDensity.density;
        double d5 = d3 * Math.cos((double)(-f3) / 180.0 * Math.PI) + d4 * Math.sin((double)(-f3) / 180.0 * Math.PI);
        double d6 = d4 * Math.cos((double)(-f3) / 180.0 * Math.PI) - d3 * Math.sin((double)(-f3) / 180.0 * Math.PI);
        double d7 = (double)n2 + d5;
        double d8 = (double)n3 + d6;
        f4 = (int)d7;
        f5 = (int)d8;
        f2 = (float)Circle.a(d2, this.d, f2) * ScreenDensity.density;
        if (this.c != null) {
            canvas.drawCircle(f4, f5, f2, this.c);
        }
        if (this.b != null) {
            canvas.drawCircle(f4, f5, f2, this.b);
        }
        return true;
    }

    public synchronized GeoPoint getGeoPoint() {
        return this.a;
    }

    public synchronized Paint getPaintFill() {
        return this.b;
    }

    public synchronized Paint getPaintStroke() {
        return this.c;
    }

    public synchronized float getRadius() {
        return this.d;
    }

    public synchronized void setGeoPoint(GeoPoint geoPoint) {
        this.a = geoPoint;
    }

    public synchronized void setPaintFill(Paint paint) {
        this.b = paint;
    }

    public synchronized void setPaintStroke(Paint paint) {
        this.c = paint;
    }

    public synchronized void setRadius(float f2) {
        Circle.a(f2);
        this.d = f2;
    }
}

