/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine.core.util;

public final class MercatorProjection {
    public static final double EARTH_CIRCUMFERENCE = 4.0075016686E7;
    public static final double LATITUDE_MAX = 85.05112877980659;
    public static final double LATITUDE_MIN = -85.05112877980659;

    public static double calculateGroundResolution(double d2, float f2) {
        long l2 = MercatorProjection.getMapSize(f2);
        return Math.cos(d2 * (Math.PI / 180)) * 4.0075016686E7 / (double)l2;
    }

    public static double deltaLat(double d2, double d3, float f2) {
        return Math.abs(MercatorProjection.pixelYToLatitude(MercatorProjection.latitudeToPixelY(d3, f2) + d2, f2) - d3);
    }

    public static long getMapSize(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("zoom level must not be negative: " + f2);
        }
        return (long)(256.0 * Math.pow(2.0, f2));
    }

    public static double latitudeToPixelY(double d2, float f2) {
        double d3 = Math.sin(d2 * (Math.PI / 180));
        long l2 = MercatorProjection.getMapSize(f2);
        double d4 = (0.5 - Math.log((1.0 + d3) / (1.0 - d3)) / (Math.PI * 4)) * (double)l2;
        return Math.min(Math.max(0.0, d4), (double)l2);
    }

    public static long latitudeToTileY(double d2, float f2) {
        return MercatorProjection.pixelYToTileY(MercatorProjection.latitudeToPixelY(d2, f2), f2);
    }

    public static double longitudeToPixelX(double d2, float f2) {
        long l2 = MercatorProjection.getMapSize(f2);
        return (d2 + 180.0) / 360.0 * (double)l2;
    }

    public static long longitudeToTileX(double d2, float f2) {
        return MercatorProjection.pixelXToTileX(MercatorProjection.longitudeToPixelX(d2, f2), f2);
    }

    public static double pixelXToLongitude(double d2, float f2) {
        long l2 = MercatorProjection.getMapSize(f2);
        if (d2 < 0.0 || d2 > (double)l2) {
            throw new IllegalArgumentException("invalid pixelX coordinate at zoom level " + f2 + ": " + d2);
        }
        return 360.0 * (d2 / (double)l2 - 0.5);
    }

    public static long pixelXToTileX(double d2, float f2) {
        return (long)Math.min(Math.max(d2 / 256.0, 0.0), Math.pow(2.0, f2) - 1.0);
    }

    public static double pixelYToLatitude(double d2, float f2) {
        long l2 = MercatorProjection.getMapSize(f2);
        if (d2 < 0.0 || d2 > (double)l2) {
            throw new IllegalArgumentException("invalid pixelY coordinate at zoom level " + f2 + ": " + d2);
        }
        double d3 = 0.5 - d2 / (double)l2;
        return 90.0 - 360.0 * Math.atan(Math.exp(-d3 * (Math.PI * 2))) / Math.PI;
    }

    public static long pixelYToTileY(double d2, float f2) {
        return (long)Math.min(Math.max(d2 / 256.0, 0.0), Math.pow(2.0, f2) - 1.0);
    }

    public static double tileXToLongitude(long l2, float f2) {
        return MercatorProjection.pixelXToLongitude(l2 * 256L, f2);
    }

    public static double tileYToLatitude(long l2, float f2) {
        return MercatorProjection.pixelYToLatitude(l2 * 256L, f2);
    }

    static double[] a(double d2, double d3) {
        double d4 = d2 * 2.003750834E7 / 180.0;
        double d5 = Math.log(Math.tan((90.0 + d3) * Math.PI / 360.0)) / (Math.PI / 180) * 2.003750834E7 / 180.0;
        return new double[]{d4, d5};
    }

    static double[] b(double d2, double d3) {
        double d4 = d2 / 2.003750834E7 * 180.0;
        double d5 = d3 / 2.003750834E7 * 180.0;
        d5 = 57.29577951308232 * (2.0 * Math.atan(Math.exp(d5 * Math.PI / 180.0)) - 1.5707963267948966);
        return new double[]{d4, d5};
    }

    private MercatorProjection() {
        throw new IllegalStateException();
    }
}

