/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine.core.model;

import com.sails.engine.core.model.CoordinatesUtil;
import java.io.Serializable;

public class GeoPoint
implements Serializable,
Comparable<GeoPoint> {
    private static final double a = 6378137.0;
    private static final long b = 1L;
    public final double latitude;
    public final double longitude;

    public static GeoPoint fromString(String object) {
        object = CoordinatesUtil.a((String)object, 2);
        return new GeoPoint((double)object[0], (double)object[1]);
    }

    public static double latitudeDistance(int n2) {
        return (double)(n2 * 360) / 4.007501668557849E7;
    }

    public static double longitudeDistance(int n2, double d2) {
        return (double)(n2 * 360) / (4.007501668557849E7 * Math.cos(Math.toRadians(d2)));
    }

    public GeoPoint(double d2, double d3) {
        CoordinatesUtil.b(d2);
        CoordinatesUtil.c(d3);
        this.latitude = d2;
        this.longitude = d3;
    }

    @Override
    public int compareTo(GeoPoint geoPoint) {
        if (this.longitude > geoPoint.longitude) {
            return 1;
        }
        if (this.longitude < geoPoint.longitude) {
            return -1;
        }
        if (this.latitude > geoPoint.latitude) {
            return 1;
        }
        if (this.latitude < geoPoint.latitude) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GeoPoint)) {
            return false;
        }
        object = (GeoPoint)object;
        if (Double.doubleToLongBits(this.latitude) != Double.doubleToLongBits(((GeoPoint)object).latitude)) {
            return false;
        }
        return Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(((GeoPoint)object).longitude);
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.latitude);
        int n2 = 31 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.longitude);
        return 31 * n2 + (int)(l2 ^ l2 >>> 32);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("latitude=");
        stringBuilder.append(this.latitude);
        stringBuilder.append(", longitude=");
        stringBuilder.append(this.longitude);
        return stringBuilder.toString();
    }
}

