/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import com.sails.engine.LocationRegion;
import com.sails.engine.MapView;
import com.sails.engine.MapViewPosition;
import com.sails.engine.MarkerManager;
import com.sails.engine.PathRoutingManager;
import com.sails.engine.PinMarkerManager;
import com.sails.engine.SAILS;
import com.sails.engine.core.model.GeoPoint;
import com.sails.engine.core.model.MapPosition;
import com.sails.engine.overlay.Circle;
import com.sails.engine.overlay.ListOverlay;
import com.sails.engine.overlay.MapJPGOverlay;
import com.sails.engine.overlay.Marker;
import com.sails.engine.overlay.OrientationMarker;
import com.sails.engine.overlay.PolygonalChain;
import com.sails.engine.overlay.Polyline;
import com.sails.engine.overlay.ScreenDensity;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class SAILSMapView
extends MapView
implements Serializable {
    final Context a;
    private MarkerManager w = new MarkerManager(this);
    private PathRoutingManager x = null;
    private PinMarkerManager y = new PinMarkerManager(this);
    private Paint z;
    SAILS b = null;
    private OrientationMarker A = new OrientationMarker(new GeoPoint(0.0, 0.0), null);
    private Bitmap B = null;
    private Bitmap C = null;
    private ListOverlay D = new ListOverlay();
    private ListOverlay E = new ListOverlay();
    private ListOverlay F = new ListOverlay();
    private List<SAILS.GeoNode> G = new ArrayList<SAILS.GeoNode>();
    private Paint H = new Paint(1);
    MapJPGOverlay c = new MapJPGOverlay(null);
    private Polyline I;
    private Marker J;
    private Circle K;
    private int L;
    public static int GENERAL = 0;
    public static int LOCATION_CENTER_LOCK = 1;
    public static int FOLLOW_PHONE_HEADING = 2;
    public static int AUTO_FLOOR_SWITCH = 4;
    public static int ALWAYS_LOCK_MAP = 8;
    private boolean M = false;
    private String N = "1";
    private double O = 0.28;
    OnMoveListener d = null;
    OnModeChangedListener o = null;
    OnZoomChangedListener p = null;
    OnRegionClickListener q = null;
    OnRegionLongClickListener r = null;
    OnClickNothingListener s = null;
    OnFloorChangedListener t = null;
    OnMapClickListener u = null;
    private String P = "";
    private int Q = Integer.MAX_VALUE;
    private boolean R = false;
    OnFeedPathListCallBack v = null;
    private a S = new a(this);
    private boolean T = false;
    private boolean U = false;

    public void setSAILSEngine(SAILS sAILS) {
        this.b = sAILS;
        if (this.b.l == null) {
            this.b.l = this;
        }
        if (this.x == null) {
            this.x = new PathRoutingManager(this);
        }
        ScreenDensity.density = this.getResources().getDisplayMetrics().density;
    }

    public void setBaseMapFloorName(@NonNull String string) {
        this.N = string;
    }

    public void setNavigationModeYOffsetHeightRatio(double d2) {
        this.O = d2;
    }

    public SAILSMapView(Context context) {
        this(context, null);
    }

    public SAILSMapView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.a = context;
        this.getOverlays().add(this.F);
        this.getDynamicOverlays().add(this.D);
        this.getDynamicOverlays().add(this.E);
        this.setJPGOverlay(this.c);
        this.c.mMapView = this;
        this.z = new Paint(1);
        this.z.setStyle(Paint.Style.FILL);
        this.z.setColor(Color.rgb((int)53, (int)179, (int)229));
        this.z.setAlpha(40);
        this.z.setStrokeWidth(5.0f);
        this.z.setStrokeJoin(Paint.Join.ROUND);
        this.M = true;
        this.l = new MapView.ZoomFinishCallback(){

            @Override
            public void onZoomFinish() {
                SAILSMapView.this.d();
            }
        };
    }

    public boolean isCenterLock() {
        return (this.L & LOCATION_CENTER_LOCK) != 0;
    }

    public void setCenterLock(boolean bl) {
        if (bl) {
            this.L |= LOCATION_CENTER_LOCK;
            if (this.o != null) {
                this.o.onModeChanged(this.L);
                return;
            }
        } else {
            this.L &= ~LOCATION_CENTER_LOCK;
            if (this.o != null) {
                this.o.onModeChanged(this.L);
            }
        }
    }

    public int getMode() {
        return this.L;
    }

    public void setMode(int n2) {
        if (this.L != n2) {
            this.L = n2;
            if ((n2 & LOCATION_CENTER_LOCK) == LOCATION_CENTER_LOCK && (n2 & FOLLOW_PHONE_HEADING) != FOLLOW_PHONE_HEADING) {
                this.setAnimatingToRotationAngle(0.0f);
            }
            this.S.a();
            if (this.o != null) {
                this.o.onModeChanged(n2);
            }
        }
    }

    public String getCurrentBrowseFloorName() {
        if (!this.P.equals("")) {
            return this.P;
        }
        return null;
    }

    @Override
    public MapViewPosition getMapViewPosition() {
        return super.getMapViewPosition();
    }

    public PinMarkerManager getPinMarkerManager() {
        return this.y;
    }

    public MarkerManager getMarkerManager() {
        return this.w;
    }

    public PathRoutingManager getRoutingManager() {
        return this.x;
    }

    public boolean isInLocationFloor() {
        if (this.b == null) {
            return false;
        }
        return this.b.getFloor().equals(this.P);
    }

    public void setLocationMarker(int n2, int n3, Paint paint, int n4) {
        if (n2 != 0) {
            this.B = this.a(this.a(this.a, n2), n4);
        }
        if (n3 != 0) {
            this.C = this.a(this.a(this.a, n3), n4);
        }
        if (paint != null) {
            this.z = paint;
        }
        this.setLocatorMarkerVisible(true);
    }

    void a(int n2, SAILS.GeoNode geoNode) {
        Drawable drawable = this.a.getResources().getDrawable(n2);
        if (this.J == null) {
            this.J = new Marker(new GeoPoint(geoNode.latitude, geoNode.longitude), Marker.boundCenterBottom(drawable));
            this.E.getOverlayItems().add(this.J);
            return;
        }
        this.J.setDrawable(Marker.boundCenterBottom(drawable));
        this.J.setGeoPoint(new GeoPoint(geoNode.latitude, geoNode.longitude));
    }

    public void setLocatorMarkerVisible(boolean bl) {
        if (!bl) {
            this.S.c();
            if (this.D.getOverlayItems().indexOf(this.A) >= 0) {
                this.D.getOverlayItems().remove(this.A);
                this.D.getOverlayItems().remove(this.K);
                return;
            }
        } else {
            if (this.A != null) {
                if (!this.getDynamicOverlays().contains(this.D)) {
                    this.getDynamicOverlays().add(this.D);
                }
                if (this.D.getOverlayItems().indexOf(this.A) < 0) {
                    this.A.setBitmap(null);
                    this.K = new Circle(new GeoPoint(0.0, 0.0), 0.0f, this.z, null);
                    this.K.setRadius(0.0f);
                    this.D.getOverlayItems().add(this.K);
                    this.D.getOverlayItems().add(this.A);
                }
            }
            this.S.d();
        }
    }

    void setGoalMarkerVisible(boolean bl) {
        if (!bl) {
            if (this.E.getOverlayItems().indexOf(this.J) >= 0) {
                this.E.getOverlayItems().remove(this.J);
                return;
            }
        } else if (this.J != null && this.E.getOverlayItems().indexOf(this.J) < 0) {
            this.E.getOverlayItems().add(this.J);
        }
    }

    void setPathVisible(boolean bl) {
        if (!bl) {
            if (this.F.getOverlayItems().indexOf(this.I) >= 0) {
                this.F.getOverlayItems().remove(this.I);
                return;
            }
        } else if (this.F.getOverlayItems().indexOf(this.I) < 0) {
            this.F.getOverlayItems().add(this.I);
        }
    }

    void setAutoRefreshLocation(boolean bl) {
        if (!bl) {
            this.b.setOnLocationChangeEventListener(null);
        }
    }

    public void lockMapRotationOnTraceAngle(boolean bl) {
        this.M = bl;
    }

    public void clear() {
        this.clearMap();
    }

    public void enableRotate(boolean bl) {
        this.h = bl;
    }

    public void enableZoomInOut(boolean bl) {
        this.i = bl;
    }

    public void setOnRegionClickListener(OnRegionClickListener onRegionClickListener) {
        this.q = onRegionClickListener;
    }

    public void setOnRegionLongClickListener(OnRegionLongClickListener onRegionLongClickListener) {
        this.r = onRegionLongClickListener;
    }

    public void setOnMapClickListener(OnMapClickListener onMapClickListener) {
        this.u = onMapClickListener;
    }

    public void setOnFloorChangedListener(OnFloorChangedListener onFloorChangedListener) {
        this.t = onFloorChangedListener;
    }

    public void setOnClickNothingListener(OnClickNothingListener onClickNothingListener) {
        this.s = onClickNothingListener;
    }

    public void setOnModeChangedListener(OnModeChangedListener onModeChangedListener) {
        this.o = onModeChangedListener;
    }

    public void setOnMoveListener(OnMoveListener onMoveListener) {
        this.d = onMoveListener;
    }

    public void setOnZoomChangedListener(OnZoomChangedListener onZoomChangedListener) {
        this.p = onZoomChangedListener;
    }

    public boolean loadCurrentLocationFloorMap() {
        if (this.P.equals(this.b.getFloor())) {
            return true;
        }
        return this.loadFloorMap(this.b.getFloor());
    }

    void a() {
        this.R = true;
    }

    public boolean loadFloorMap(String object) {
        if (this.b == null) {
            return false;
        }
        this.e();
        Object object2 = this.R ? SAILSMapFormat.JPG : this.b.getMapFormat((String)object);
        if (object2 == SAILSMapFormat.VOID) {
            return false;
        }
        if (!this.P.equals(object)) {
            this.stopAnimation();
        }
        if (this.t != null && !this.P.equals("")) {
            this.t.onFloorChangedBefore(this.P);
        }
        this.P = object;
        this.baseMapMaskEnabled = !this.P.equals(this.N);
        this.w.a();
        this.y.refreshMarker();
        if (this.b.getFloor().equals(this.P)) {
            if (!this.getDynamicOverlays().contains(this.D)) {
                this.getDynamicOverlays().add(this.D);
            }
        } else {
            this.setCenterLock(false);
        }
        this.clearMap();
        this.setJPGOverlay(null);
        this.redraw();
        if (object2 == SAILSMapFormat.Vector) {
            if ((object = this.b.a((String)object)) == null) {
                return false;
            }
            object2 = new File(((File)object).getParentFile(), "render.xml");
            if (!((File)object2).exists()) {
                return false;
            }
            this.setMapAndRenderFile((File)object, (File)object2);
            this.setJPGOverlay(null);
            if (this.t != null) {
                this.t.onFloorChangedAfter(this.P);
            }
            return true;
        }
        if (object2 == SAILSMapFormat.JPG) {
            this.R = false;
            if ((object = this.b.b((String)object)) == null) {
                return false;
            }
            if (this.c.isLoadMap()) {
                this.c.clear();
            }
            object2 = SAILSMapView.a((File)object, 384, 512);
            this.c.loadJPGMap((Bitmap)object2);
            this.setJPGOverlay(this.c);
            this.getRidOfMapBoundary();
            this.getMapZoomControls().b(14.0f);
            this.getMapZoomControls().a(22.0f);
            this.clearMap();
            this.redrawMapItems();
            this.getMapViewPosition().setMapPosition(new MapPosition(this.c.getBMPCenter(), 15.0f));
            this.setRotationAngle(0.0f);
            if (this.t != null) {
                this.t.onFloorChangedAfter(this.P);
            }
            return true;
        }
        return false;
    }

    private void e() {
        if (!this.isBaseMapLoaded) {
            File file = this.b.a("-20");
            if (file == null) {
                return;
            }
            File file2 = new File(file.getParentFile(), "render.xml");
            if (!file2.exists()) {
                return;
            }
            this.a(file, file2);
        }
    }

    static Bitmap a(File file, int n2, int n3) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        new BitmapFactory.Options().inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)file.getPath(), (BitmapFactory.Options)options);
        options.inSampleSize = SAILSMapView.a(options, n2, n3);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)file.getPath(), (BitmapFactory.Options)options);
    }

    static int a(BitmapFactory.Options options, int n2, int n3) {
        int n4 = options.outHeight;
        int n5 = options.outWidth;
        int n6 = 1;
        if (n4 > n3 || n5 > n2) {
            n4 /= 2;
            n5 /= 2;
            while (n4 / n6 > n3 && n5 / n6 > n2) {
                n6 *= 2;
            }
        }
        return n6;
    }

    @Override
    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putString("sailsmap_floor", this.P);
        bundle.putInt("sailsmap_mode", this.L);
        if (this.b != null) {
            bundle.putBoolean("sailsmap_sailsengine_started", this.T);
        }
    }

    @Override
    public void loadSavedInstanceState(Bundle bundle) {
        super.loadSavedInstanceState(bundle);
        Object object = bundle.getString("sailsmap_floor");
        this.loadFloorMap((String)object);
        if (bundle.getBoolean("sailsmap_sailsengine_started", false) && this.b != null) {
            this.b.startLocatingEngine();
            object = new Runnable(){

                @Override
                public void run() {
                    SAILSMapView.this.setLocatorMarkerVisible(true);
                }
            };
            new Handler().postDelayed((Runnable)object, 100L);
        }
        this.L = bundle.getInt("sailsmap_mode", GENERAL);
    }

    @Override
    public void autoSetMapZoomAndView() {
        super.autoSetMapZoomAndView();
    }

    @Override
    public void autoSetMapZoomAndView(List<GeoPoint> list) {
        super.autoSetMapZoomAndView(list);
    }

    @Override
    public void autoSetMapZoomAndView(List<GeoPoint> list, int n2) {
        super.autoSetMapZoomAndView(list, n2);
    }

    @Override
    public float getRotationAngle() {
        return super.getRotationAngle();
    }

    @Override
    public void redraw() {
        super.redraw();
    }

    @Override
    public void setAnimatingToRotationAngle(float f2) {
        super.setAnimatingToRotationAngle(f2);
    }

    @Override
    public void setAnimationToZoom(float f2) {
        super.setAnimationToZoom(f2);
    }

    @Override
    public void setRotationAngle(float f2) {
        super.setRotationAngle(f2);
    }

    @Override
    public void setAnimationMoveMapTo(GeoPoint geoPoint) {
        super.setAnimationMoveMapTo(geoPoint);
    }

    public void setAnimationMoveMapToMyLocation() {
        GeoPoint geoPoint = null;
        if (!(this.b == null || Double.isNaN(this.b.getLatitude()) && Double.isNaN(this.b.getLongitude()))) {
            geoPoint = new GeoPoint(this.b.getLongitude(), this.b.getLatitude());
        }
        this.setAnimationMoveMapTo(geoPoint);
    }

    @Override
    public void zoomIn() {
        super.zoomIn();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                SAILSMapView.this.S.a();
            }
        }, 300L);
    }

    @Override
    public void zoomOut() {
        super.zoomOut();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                SAILSMapView.this.S.a();
            }
        }, 300L);
    }

    public void onResume() {
        if (this.b != null && this.T) {
            this.b.startLocatingEngine();
            this.setLocatorMarkerVisible(true);
        }
        if (this.U) {
            this.x.e = true;
            this.x.sleep(2000L);
        }
    }

    public void onPause() {
        if (this.b != null) {
            this.T = this.b.isLocationEngineStarted();
            this.b.stopLocatingEngine();
        }
        this.U = false;
        if (this.x != null && this.x.e) {
            this.U = true;
            this.x.e = false;
        }
    }

    public void setZoomLevelMin(byte by) {
        this.getMapZoomControls().b((float)by);
    }

    @Override
    protected boolean onClickWithoutConvert(int n2, int n3) {
        MarkerManager.LocationRegionMarker locationRegionMarker;
        if (this.u != null) {
            return this.u.onClick(n2, n3);
        }
        if (this.getPinMarkerManager().c != null && (locationRegionMarker = this.getPinMarkerManager().a(n2, n3)) != null) {
            this.getPinMarkerManager().c.OnClick(locationRegionMarker);
        }
        return false;
    }

    @Override
    protected void onLongClick(int n2, int n3) {
        super.onLongClick(n2, n3);
        if (this.b == null || this.r == null) {
            return;
        }
        Object object = this.b.getLocationRegionList(this.P);
        ArrayList<LocationRegion> arrayList = new ArrayList<LocationRegion>();
        if (object == null) {
            return;
        }
        GeoPoint geoPoint = this.getProjection().fromPixels(n2, n3);
        Iterator<LocationRegion> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!((LocationRegion)object).isInRegion(geoPoint.longitude, geoPoint.latitude)) continue;
            arrayList.add((LocationRegion)object);
        }
        if (arrayList.size() > 0) {
            Collections.sort(arrayList, new LocationRegion.b());
            this.r.onLongClick(arrayList);
        }
    }

    @Override
    protected void onClick(int n2, int n3) {
        if (this.b == null) {
            return;
        }
        this.getPinMarkerManager().a(n2, n3, this.b);
        if (this.q == null && this.s == null) {
            return;
        }
        Object object = this.b.getLocationRegionList(this.P);
        ArrayList<LocationRegion> arrayList = new ArrayList<LocationRegion>();
        if (object == null) {
            return;
        }
        GeoPoint geoPoint = this.getProjection().fromPixels(n2, n3);
        Iterator<LocationRegion> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!((LocationRegion)object).isInRegion(geoPoint.longitude, geoPoint.latitude) || ((LocationRegion)object).type != null && (((LocationRegion)object).type.equals("boundary") || ((LocationRegion)object).type.equals("freedom") || ((LocationRegion)object).type.equals("plaza") || ((LocationRegion)object).type.equals("lock") || ((LocationRegion)object).type.equals("parking"))) continue;
            arrayList.add((LocationRegion)object);
        }
        if (arrayList.size() > 0) {
            Collections.sort(arrayList, new LocationRegion.b());
            this.q.onClick(arrayList);
            return;
        }
        if (this.s != null) {
            this.s.onClick();
        }
    }

    @Override
    protected void onMove(int n2, int n3) {
        super.onMove(n2, n3);
        if ((this.L & ALWAYS_LOCK_MAP) != ALWAYS_LOCK_MAP) {
            this.L &= ~LOCATION_CENTER_LOCK;
            this.L &= ~FOLLOW_PHONE_HEADING;
            if (this.o != null) {
                this.o.onModeChanged(this.L);
            }
        }
        if (this.d != null) {
            this.d.onMove(n2, n3);
        }
    }

    @Override
    protected void onRotate() {
        if ((this.L & ALWAYS_LOCK_MAP) != ALWAYS_LOCK_MAP) {
            this.L &= ~FOLLOW_PHONE_HEADING;
            if (this.o != null) {
                this.o.onModeChanged(this.L);
            }
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    void setFeedPathListCallBack(OnFeedPathListCallBack onFeedPathListCallBack) {
        this.v = onFeedPathListCallBack;
        this.H.setStyle(Paint.Style.STROKE);
        this.H.setColor(-65536);
        this.H.setAlpha(100);
        this.H.setStrokeWidth(5.0f);
        this.H.setStrokeJoin(Paint.Join.ROUND);
        this.I = new Polyline(new PolygonalChain(null), this.H);
        this.F.getOverlayItems().clear();
        this.F.getOverlayItems().add(this.I);
    }

    private Bitmap a(Context context, int n2) {
        return BitmapFactory.decodeStream((InputStream)context.getResources().openRawResource(n2), null, (BitmapFactory.Options)this.a(1));
    }

    private BitmapFactory.Options a(int n2) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        new BitmapFactory.Options().inSampleSize = n2;
        return options;
    }

    private Bitmap a(Bitmap bitmap, int n2) {
        float f2 = 1.0f;
        if (this.getResources() != null) {
            f2 = this.getResources().getDisplayMetrics().density;
        }
        n2 = (int)((float)n2 * f2 + 0.5f);
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n2, (int)n2, (boolean)true);
    }

    void b() {
        this.S.d();
    }

    void c() {
        this.S.c();
    }

    void d() {
        this.S.a();
    }

    @Override
    public void onZoomLevelChange(float f2) {
        super.onZoomLevelChange(f2);
        if (this.p != null) {
            this.p.onZoomChanged(f2);
        }
        if ((this.L & LOCATION_CENTER_LOCK) != LOCATION_CENTER_LOCK || (this.L & FOLLOW_PHONE_HEADING) != FOLLOW_PHONE_HEADING) {
            return;
        }
        if (this.b == null || !this.b.isLocationFix()) {
            return;
        }
        double d2 = this.b.getProcessLongitude();
        double d3 = this.b.getProcessLatitude();
        if (Double.isNaN(d3) || Double.isNaN(d2) || !this.isInMap(new GeoPoint(d3, d3))) {
            return;
        }
        double d4 = this.b.getMapViewRotation();
        this.setAnimationMoveMapTo(this.a(new GeoPoint(d3, d2), d4));
        this.setAnimatingToRotationAngle((float)(-d4));
    }

    private GeoPoint a(GeoPoint geoPoint, double d2) {
        if ((this.L & LOCATION_CENTER_LOCK) != LOCATION_CENTER_LOCK || (this.L & FOLLOW_PHONE_HEADING) != FOLLOW_PHONE_HEADING) {
            return geoPoint;
        }
        geoPoint = this.getProjection().toPixels(geoPoint, null);
        ((Point)geoPoint).y = (int)((double)((Point)geoPoint).y + (double)((float)(-this.getHeight()) / ScreenDensity.density) * this.O * Math.cos(Math.toRadians(-d2)));
        ((Point)geoPoint).x = (int)((double)((Point)geoPoint).x + (double)((float)(-this.getHeight()) / ScreenDensity.density) * this.O * Math.sin(Math.toRadians(-d2)));
        return this.getProjection().fromPixels(((Point)geoPoint).x, ((Point)geoPoint).y);
    }

    static /* synthetic */ String b(SAILSMapView sAILSMapView) {
        return sAILSMapView.P;
    }

    static /* synthetic */ ListOverlay c(SAILSMapView sAILSMapView) {
        return sAILSMapView.D;
    }

    static /* synthetic */ OrientationMarker d(SAILSMapView sAILSMapView) {
        return sAILSMapView.A;
    }

    static /* synthetic */ Circle e(SAILSMapView sAILSMapView) {
        return sAILSMapView.K;
    }

    static /* synthetic */ Bitmap f(SAILSMapView sAILSMapView) {
        return sAILSMapView.C;
    }

    static /* synthetic */ Bitmap g(SAILSMapView sAILSMapView) {
        return sAILSMapView.B;
    }

    static /* synthetic */ boolean h(SAILSMapView sAILSMapView) {
        return sAILSMapView.M;
    }

    static /* synthetic */ int i(SAILSMapView sAILSMapView) {
        return sAILSMapView.L;
    }

    static /* synthetic */ GeoPoint a(SAILSMapView sAILSMapView, GeoPoint geoPoint, double d2) {
        return sAILSMapView.a(geoPoint, d2);
    }

    static class com.sails.engine.SAILSMapView$a
    extends Handler {
        public boolean a = true;
        public int b = 20;
        int c = 0;
        boolean d = true;
        private float e = 0.0f;
        private WeakReference<SAILSMapView> f;
        private float g = 0.0f;
        private int h = 0;

        void a() {
            this.d = true;
            this.c = 1000;
        }

        private int e() {
            try {
                class A
                implements FileFilter {
                    A() {
                    }

                    @Override
                    public boolean accept(File file) {
                        return Pattern.matches("cpu[0-9]+", file.getName());
                    }
                }
                return new File("/sys/devices/system/cpu/").listFiles(new A()).length;
            }
            catch (Exception exception) {
                return 1;
            }
        }

        com.sails.engine.SAILSMapView$a(SAILSMapView sAILSMapView) {
            this.f = new WeakReference<SAILSMapView>(sAILSMapView);
            if (this.e() == 1) {
                this.b = 100;
            }
        }

        public void b() {
        }

        /*
         * Unable to fully structure code
         */
        public void handleMessage(Message var1_1) {
            block17: {
                block23: {
                    block18: {
                        block19: {
                            block20: {
                                block21: {
                                    block22: {
                                        var1_1 = (SAILSMapView)this.f.get();
                                        if (var1_1 == null || var1_1.b == null || !var1_1.b.isLocationEngineStarted()) break block17;
                                        var3_2 = var1_1.b.getLongitude();
                                        var5_3 = var1_1.b.getLatitude();
                                        var7_4 = var1_1.b.getProcessLongitude();
                                        var9_7 = var1_1.b.getProcessLatitude();
                                        var11_8 = var1_1.b.getAccuracy();
                                        if (Double.isNaN(var3_2) || Double.isNaN(var5_3) || Double.isNaN(var11_8) || var1_1.b.isUseGPS() && !var1_1.isInMap(new GeoPoint(Double.isNaN(var5_3) != false ? 0.0 : var5_3, Double.isNaN(var3_2) != false ? 0.0 : var3_2))) break block18;
                                        if (!var1_1.b.getFloor().equals(SAILSMapView.b((SAILSMapView)var1_1))) break block19;
                                        if (!var1_1.getDynamicOverlays().contains(SAILSMapView.c((SAILSMapView)var1_1))) {
                                            var1_1.getDynamicOverlays().add(SAILSMapView.c((SAILSMapView)var1_1));
                                        }
                                        var2_9 = new GeoPoint(var9_7, var7_4);
                                        SAILSMapView.d((SAILSMapView)var1_1).setGeoPoint(var2_9);
                                        if (SAILSMapView.e((SAILSMapView)var1_1) != null) {
                                            SAILSMapView.e((SAILSMapView)var1_1).setGeoPoint(var2_9);
                                            var13_10 = var1_1.b.getAccuracy();
                                            this.e = (float)(0.98 * (double)this.e + 0.02 * var13_10 * var1_1.b.getMapScale());
                                            SAILSMapView.e((SAILSMapView)var1_1).setRadius(this.e);
                                        }
                                        var13_11 = (float)var1_1.b.getUserHeading();
                                        if (var1_1.b.isHeadingAvailable()) {
                                            SAILSMapView.d((SAILSMapView)var1_1).setBitmap(SAILSMapView.f((SAILSMapView)var1_1));
                                            SAILSMapView.d((SAILSMapView)var1_1).setRotation(var13_11);
                                        } else {
                                            SAILSMapView.d((SAILSMapView)var1_1).setBitmap(SAILSMapView.g((SAILSMapView)var1_1));
                                            SAILSMapView.d((SAILSMapView)var1_1).setRotation(var13_11);
                                        }
                                        if (SAILSMapView.h((SAILSMapView)var1_1)) {
                                            var13_11 = (float)var1_1.b.getMapViewRotation();
                                        }
                                        if ((SAILSMapView.i((SAILSMapView)var1_1) & SAILSMapView.LOCATION_CENTER_LOCK) != SAILSMapView.LOCATION_CENTER_LOCK) break block20;
                                        var14_12 = SAILSMapView.a((SAILSMapView)var1_1, var2_9, var13_11);
                                        var7_5 = var1_1.getProjection().toPixels(var14_12, null);
                                        var8_13 = var1_1.getProjection().toPixels(var1_1.getMapViewPosition().getCenter(), null);
                                        var15_15 = Math.pow(Math.pow(var7_5.x - var8_13.x, 2.0) + Math.pow(var7_5.y - var8_13.y, 2.0), 0.5) / (double)ScreenDensity.density;
                                        var7_6 = false;
                                        var8_14 = false;
                                        if (var15_15 > 10.0 || this.c > 150) {
                                            var7_6 = true;
                                            this.c = 0;
                                        }
                                        if ((SAILSMapView.i((SAILSMapView)var1_1) & SAILSMapView.FOLLOW_PHONE_HEADING) != SAILSMapView.FOLLOW_PHONE_HEADING || !var1_1.b.isHeadingAvailable()) break block21;
                                        if (!(Math.cos(Math.toRadians(this.g - var13_11)) < 0.995) && !this.d) break block22;
                                        this.g = var13_11;
                                        var7_6 = true;
                                        var8_14 = true;
                                        this.c = 0;
                                        ** GOTO lbl-1000
                                    }
                                    if (Math.cos(Math.toRadians(this.g - var13_11)) < 0.999) {
                                        ++this.h;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        this.h = 0;
                                    }
                                    if (this.h > 20) {
                                        this.h = 0;
                                        this.d = true;
                                    } else {
                                        this.d = false;
                                    }
                                }
                                if (var7_6) {
                                    var1_1.setAnimationMoveMapTo(SAILSMapView.a((SAILSMapView)var1_1, var2_9, var13_11));
                                }
                                if (var8_14) {
                                    var1_1.setAnimatingToRotationAngle(-var13_11);
                                }
                                break block23;
                            }
                            this.d = true;
                            break block23;
                        }
                        if (var1_1.getDynamicOverlays().contains(SAILSMapView.c((SAILSMapView)var1_1))) {
                            var1_1.getDynamicOverlays().remove(SAILSMapView.c((SAILSMapView)var1_1));
                        }
                        break block23;
                    }
                    if (SAILSMapView.d((SAILSMapView)var1_1) != null) {
                        SAILSMapView.d((SAILSMapView)var1_1).setBitmap(null);
                    }
                    if (SAILSMapView.e((SAILSMapView)var1_1) != null) {
                        SAILSMapView.e((SAILSMapView)var1_1).setRadius(0.0f);
                    }
                    this.c = 100;
                }
                if (!(var1_1.b.getFloor().equals(SAILSMapView.b((SAILSMapView)var1_1)) || (SAILSMapView.i((SAILSMapView)var1_1) & SAILSMapView.AUTO_FLOOR_SWITCH) != SAILSMapView.AUTO_FLOOR_SWITCH || var1_1.b.getFloor().equals("") || Double.isNaN(var3_2) || Double.isNaN(var5_3))) {
                    var1_1.loadCurrentLocationFloorMap();
                }
                ++this.c;
                var1_1.invalidate();
            }
            if (this.a) {
                this.a(this.b);
            }
        }

        public void c() {
            this.a = false;
        }

        public void d() {
            this.a = true;
            this.a(0L);
        }

        public void a(long l2) {
            this.removeMessages(0);
            this.sendMessageDelayed(this.obtainMessage(0), l2);
        }
    }

    static interface OnFeedPathListCallBack {
        public void onFeed();
    }

    public static interface OnZoomChangedListener {
        public void onZoomChanged(float var1);
    }

    public static interface OnMoveListener {
        public void onMove(int var1, int var2);
    }

    public static interface OnModeChangedListener {
        public void onModeChanged(int var1);
    }

    public static interface OnFloorChangedListener {
        public void onFloorChangedBefore(String var1);

        public void onFloorChangedAfter(String var1);
    }

    public static interface OnRegionLongClickListener {
        public void onLongClick(List<LocationRegion> var1);
    }

    public static interface OnRegionClickListener {
        public void onClick(List<LocationRegion> var1);
    }

    public static interface OnClickNothingListener {
        public void onClick();
    }

    public static interface OnMapClickListener {
        public boolean onClick(int var1, int var2);
    }

    public static enum SAILSMapFormat {
        Vector,
        JPG,
        VOID;

    }
}

