/*
 * Decompiled with CFR 0.152.
 */
package com.shinyhut.vernacular.utils;

import java.awt.event.KeyEvent;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class KeySyms {
    private static final Map<Integer, Integer> KEYCODES = new ConcurrentHashMap<Integer, Integer>();
    private static final Map<Character, Integer> CONTROL_CHARACTERS = new ConcurrentHashMap<Character, Integer>();
    private static final Map<Character, Integer> SHIFT_CONTROL_CHARACTERS = new ConcurrentHashMap<Character, Integer>();

    public static Optional<Integer> forEvent(KeyEvent keyEvent) {
        int keyCode = keyEvent.getKeyCode();
        char symbol = keyEvent.getKeyChar();
        if (KEYCODES.containsKey(keyCode)) {
            return Optional.of(KEYCODES.get(keyCode));
        }
        if (!keyEvent.isShiftDown() && CONTROL_CHARACTERS.containsKey(Character.valueOf(symbol))) {
            return Optional.of(CONTROL_CHARACTERS.get(Character.valueOf(symbol)));
        }
        if (keyEvent.isShiftDown() && SHIFT_CONTROL_CHARACTERS.containsKey(Character.valueOf(symbol))) {
            return Optional.of(SHIFT_CONTROL_CHARACTERS.get(Character.valueOf(symbol)));
        }
        if (symbol != '\uffff') {
            return Optional.of(Integer.valueOf(symbol));
        }
        return Optional.empty();
    }

    public static Optional<Integer> forKeyCode(int keyCode) {
        return Optional.ofNullable(KEYCODES.get(keyCode));
    }

    static {
        KEYCODES.put(8, 65288);
        KEYCODES.put(9, 65289);
        KEYCODES.put(10, 65293);
        KEYCODES.put(27, 65307);
        KEYCODES.put(155, 65379);
        KEYCODES.put(127, 65535);
        KEYCODES.put(36, 65360);
        KEYCODES.put(35, 65367);
        KEYCODES.put(33, 65365);
        KEYCODES.put(34, 65366);
        KEYCODES.put(37, 65361);
        KEYCODES.put(38, 65362);
        KEYCODES.put(39, 65363);
        KEYCODES.put(40, 65364);
        KEYCODES.put(112, 65470);
        KEYCODES.put(113, 65471);
        KEYCODES.put(114, 65472);
        KEYCODES.put(115, 65473);
        KEYCODES.put(116, 65474);
        KEYCODES.put(117, 65475);
        KEYCODES.put(118, 65476);
        KEYCODES.put(119, 65477);
        KEYCODES.put(120, 65478);
        KEYCODES.put(121, 65479);
        KEYCODES.put(122, 65480);
        KEYCODES.put(123, 65481);
        KEYCODES.put(16, 65505);
        KEYCODES.put(17, 65507);
        KEYCODES.put(157, 65511);
        KEYCODES.put(18, 65513);
        CONTROL_CHARACTERS.put(Character.valueOf('\u0000'), 64);
        CONTROL_CHARACTERS.put(Character.valueOf('\u0001'), 97);
        CONTROL_CHARACTERS.put(Character.valueOf('\u0002'), 98);
        CONTROL_CHARACTERS.put(Character.valueOf('\u0003'), 99);
        CONTROL_CHARACTERS.put(Character.valueOf('\u0004'), 100);
        CONTROL_CHARACTERS.put(Character.valueOf('\u0005'), 101);
        CONTROL_CHARACTERS.put(Character.valueOf('\u0006'), 102);
        CONTROL_CHARACTERS.put(Character.valueOf('\u0007'), 103);
        CONTROL_CHARACTERS.put(Character.valueOf('\b'), 104);
        CONTROL_CHARACTERS.put(Character.valueOf('\t'), 105);
        CONTROL_CHARACTERS.put(Character.valueOf('\n'), 106);
        CONTROL_CHARACTERS.put(Character.valueOf('\u000b'), 107);
        CONTROL_CHARACTERS.put(Character.valueOf('\f'), 108);
        CONTROL_CHARACTERS.put(Character.valueOf('\r'), 109);
        CONTROL_CHARACTERS.put(Character.valueOf('\u000e'), 110);
        CONTROL_CHARACTERS.put(Character.valueOf('\u000f'), 111);
        CONTROL_CHARACTERS.put(Character.valueOf('\u0010'), 112);
        CONTROL_CHARACTERS.put(Character.valueOf('\u0011'), 113);
        CONTROL_CHARACTERS.put(Character.valueOf('\u0012'), 114);
        CONTROL_CHARACTERS.put(Character.valueOf('\u0013'), 115);
        CONTROL_CHARACTERS.put(Character.valueOf('\u0014'), 116);
        CONTROL_CHARACTERS.put(Character.valueOf('\u0015'), 117);
        CONTROL_CHARACTERS.put(Character.valueOf('\u0016'), 118);
        CONTROL_CHARACTERS.put(Character.valueOf('\u0017'), 119);
        CONTROL_CHARACTERS.put(Character.valueOf('\u0018'), 120);
        CONTROL_CHARACTERS.put(Character.valueOf('\u0019'), 121);
        CONTROL_CHARACTERS.put(Character.valueOf('\u001a'), 122);
        CONTROL_CHARACTERS.put(Character.valueOf('\u001b'), 91);
        CONTROL_CHARACTERS.put(Character.valueOf('\u001c'), 92);
        CONTROL_CHARACTERS.put(Character.valueOf('\u001d'), 93);
        CONTROL_CHARACTERS.put(Character.valueOf('\u001e'), 94);
        CONTROL_CHARACTERS.put(Character.valueOf('\u001f'), 95);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\u0001'), 65);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\u0002'), 66);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\u0003'), 67);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\u0004'), 68);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\u0005'), 69);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\u0006'), 70);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\u0007'), 71);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\b'), 72);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\t'), 73);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\n'), 74);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\u000b'), 75);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\f'), 76);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\r'), 77);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\u000e'), 78);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\u000f'), 79);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\u0010'), 80);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\u0011'), 81);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\u0012'), 82);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\u0013'), 83);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\u0014'), 84);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\u0015'), 85);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\u0016'), 86);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\u0017'), 87);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\u0018'), 88);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\u0019'), 89);
        SHIFT_CONTROL_CHARACTERS.put(Character.valueOf('\u001a'), 90);
    }
}

