/*
 * Decompiled with CFR 0.152.
 */
package com.shinyhut.vernacular.protocol.messages;

import com.shinyhut.vernacular.client.exceptions.HandshakingFailedException;
import com.shinyhut.vernacular.protocol.messages.ErrorMessage;
import com.shinyhut.vernacular.protocol.messages.SecurityType;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ServerSecurityTypes {
    private final List<SecurityType> securityTypes;

    private ServerSecurityTypes(List<SecurityType> securityTypes) {
        this.securityTypes = securityTypes;
    }

    public List<SecurityType> getSecurityTypes() {
        return this.securityTypes;
    }

    public static ServerSecurityTypes decode(InputStream in) throws HandshakingFailedException, IOException {
        DataInputStream dataInput = new DataInputStream(in);
        int typeCount = dataInput.readByte();
        if (typeCount == 0) {
            ErrorMessage errorMessage = ErrorMessage.decode(in);
            throw new HandshakingFailedException(errorMessage.getMessage());
        }
        ArrayList<SecurityType> types = new ArrayList<SecurityType>();
        for (int i = 0; i < typeCount; ++i) {
            byte type = dataInput.readByte();
            if (type >= SecurityType.values().length) continue;
            types.add(SecurityType.values()[type]);
        }
        return new ServerSecurityTypes(types);
    }
}

