/*
 * Decompiled with CFR 0.152.
 */
package com.shinyhut.vernacular.protocol.messages;

import com.shinyhut.vernacular.client.exceptions.AuthenticationFailedException;
import com.shinyhut.vernacular.protocol.messages.ErrorMessage;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SecurityResult {
    private final boolean success;
    private final String errorMessage;

    private SecurityResult(boolean success) {
        this(success, null);
    }

    private SecurityResult(boolean success, String errorMessage) {
        this.success = success;
        this.errorMessage = errorMessage;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static SecurityResult decode(InputStream in) throws AuthenticationFailedException, IOException {
        SecurityResult result;
        DataInputStream dataInput = new DataInputStream(in);
        int resultCode = dataInput.readInt();
        if (resultCode == 1) {
            ErrorMessage errorMessage = ErrorMessage.decode(in);
            result = new SecurityResult(false, errorMessage.getMessage());
        } else {
            result = new SecurityResult(true);
        }
        return result;
    }
}

