/*
 * Decompiled with CFR 0.152.
 */
package com.shinyhut.vernacular.protocol.messages;

import com.shinyhut.vernacular.client.exceptions.InvalidMessageException;
import com.shinyhut.vernacular.client.exceptions.VncException;
import com.shinyhut.vernacular.protocol.messages.Encodable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProtocolVersion
implements Encodable {
    private static final Pattern PROTOCOL_VERSION_MESSAGE = Pattern.compile("RFB (\\d{3})\\.(\\d{3})");
    private final int major;
    private final int minor;

    public ProtocolVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        out.write(String.format("RFB %03d.%03d\n", this.major, this.minor).getBytes(Charset.forName("US-ASCII")));
    }

    public static ProtocolVersion decode(InputStream in) throws VncException, IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        String message = br.readLine();
        Matcher matcher = PROTOCOL_VERSION_MESSAGE.matcher(message);
        if (matcher.matches()) {
            String major = matcher.group(1);
            String minor = matcher.group(2);
            return new ProtocolVersion(Integer.parseInt(major), Integer.parseInt(minor));
        }
        throw new InvalidMessageException("ProtocolVersion");
    }
}

