/*
 * Decompiled with CFR 0.152.
 */
package com.shinyhut.vernacular.protocol.messages;

import com.shinyhut.vernacular.protocol.messages.Encodable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class PointerEvent
implements Encodable {
    private final int x;
    private final int y;
    private final List<Boolean> buttons;

    public PointerEvent(int x, int y, List<Boolean> buttons) {
        this.x = x;
        this.y = y;
        this.buttons = buttons;
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DataOutputStream dataOutput = new DataOutputStream(out);
        dataOutput.write(5);
        dataOutput.write(this.buttonMask());
        dataOutput.writeShort(this.x);
        dataOutput.writeShort(this.y);
    }

    private byte buttonMask() {
        byte mask = 0;
        for (int i = 0; i < 8 && i < this.buttons.size(); ++i) {
            if (!this.buttons.get(i).booleanValue()) continue;
            mask = (byte)(mask | 128 >> 7 - i);
        }
        return mask;
    }
}

