/*
 * Decompiled with CFR 0.152.
 */
package com.shinyhut.vernacular.protocol.messages;

import com.shinyhut.vernacular.protocol.messages.Encodable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PixelFormat
implements Encodable {
    private final int bitsPerPixel;
    private final int depth;
    private final boolean bigEndian;
    private final boolean trueColor;
    private final int redMax;
    private final int greenMax;
    private final int blueMax;
    private final int redShift;
    private final int greenShift;
    private final int blueShift;

    public PixelFormat(int bitsPerPixel, int depth, boolean bigEndian, boolean trueColor, int redMax, int greenMax, int blueMax, int redShift, int greenShift, int blueShift) {
        this.bitsPerPixel = bitsPerPixel;
        this.depth = depth;
        this.bigEndian = bigEndian;
        this.trueColor = trueColor;
        this.redMax = redMax;
        this.greenMax = greenMax;
        this.blueMax = blueMax;
        this.redShift = redShift;
        this.greenShift = greenShift;
        this.blueShift = blueShift;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public int getBytesPerPixel() {
        return this.bitsPerPixel / 8;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public boolean isTrueColor() {
        return this.trueColor;
    }

    public int getRedMax() {
        return this.redMax;
    }

    public int getGreenMax() {
        return this.greenMax;
    }

    public int getBlueMax() {
        return this.blueMax;
    }

    public int getRedShift() {
        return this.redShift;
    }

    public int getGreenShift() {
        return this.greenShift;
    }

    public int getBlueShift() {
        return this.blueShift;
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DataOutputStream dataOutput = new DataOutputStream(out);
        dataOutput.writeByte(this.bitsPerPixel);
        dataOutput.writeByte(this.depth);
        dataOutput.writeBoolean(this.bigEndian);
        dataOutput.writeBoolean(this.trueColor);
        dataOutput.writeShort(this.redMax);
        dataOutput.writeShort(this.greenMax);
        dataOutput.writeShort(this.blueMax);
        dataOutput.writeByte(this.redShift);
        dataOutput.writeByte(this.greenShift);
        dataOutput.writeByte(this.blueShift);
        dataOutput.write(new byte[3]);
    }

    public static PixelFormat decode(InputStream in) throws IOException {
        DataInputStream dataInput = new DataInputStream(in);
        int bpp = dataInput.readUnsignedByte();
        int depth = dataInput.readUnsignedByte();
        boolean bigEndian = dataInput.readBoolean();
        boolean trueColor = dataInput.readBoolean();
        int readMax = dataInput.readUnsignedShort();
        int greenMax = dataInput.readUnsignedShort();
        int blueMax = dataInput.readUnsignedShort();
        int redShift = dataInput.readUnsignedByte();
        int greenShift = dataInput.readUnsignedByte();
        int blueShift = dataInput.readUnsignedByte();
        dataInput.readFully(new byte[3]);
        return new PixelFormat(bpp, depth, bigEndian, trueColor, readMax, greenMax, blueMax, redShift, greenShift, blueShift);
    }
}

