/*
 * Decompiled with CFR 0.152.
 */
package com.shinyhut.vernacular.protocol.handshaking;

import com.shinyhut.vernacular.client.VncSession;
import com.shinyhut.vernacular.client.exceptions.NoSupportedSecurityTypesException;
import com.shinyhut.vernacular.client.exceptions.VncException;
import com.shinyhut.vernacular.protocol.auth.NoSecurityHandler;
import com.shinyhut.vernacular.protocol.auth.SecurityHandler;
import com.shinyhut.vernacular.protocol.auth.VncAuthenticationHandler;
import com.shinyhut.vernacular.protocol.messages.SecurityType;
import com.shinyhut.vernacular.protocol.messages.ServerSecurityTypes;
import java.io.IOException;

public class SecurityTypeNegotiator {
    public SecurityHandler negotiate(VncSession session) throws IOException, VncException {
        SecurityHandler securityHandler;
        ServerSecurityTypes serverSecurityTypes = ServerSecurityTypes.decode(session.getInputStream());
        if (serverSecurityTypes.getSecurityTypes().contains((Object)SecurityType.NONE)) {
            securityHandler = new NoSecurityHandler();
        } else if (serverSecurityTypes.getSecurityTypes().contains((Object)SecurityType.VNC)) {
            securityHandler = new VncAuthenticationHandler();
        } else {
            throw new NoSupportedSecurityTypesException();
        }
        return securityHandler;
    }
}

