/*
 * Decompiled with CFR 0.152.
 */
package com.shinyhut.vernacular.protocol.handshaking;

import com.shinyhut.vernacular.client.VncSession;
import com.shinyhut.vernacular.client.exceptions.UnsupportedProtocolVersionException;
import com.shinyhut.vernacular.client.exceptions.VncException;
import com.shinyhut.vernacular.protocol.messages.ProtocolVersion;
import java.io.IOException;

public class ProtocolVersionNegotiator {
    private static final int MIN_MAJOR_VERSION = 3;
    private static final int MIN_MINOR_VERSION = 8;

    public void negotiate(VncSession session) throws IOException, VncException {
        ProtocolVersion serverVersion = ProtocolVersion.decode(session.getInputStream());
        if (!this.isSupported(serverVersion)) {
            throw new UnsupportedProtocolVersionException(serverVersion.getMajor(), serverVersion.getMinor(), 3, 8);
        }
        ProtocolVersion clientVersion = new ProtocolVersion(3, 8);
        clientVersion.encode(session.getOutputStream());
    }

    private boolean isSupported(ProtocolVersion serverVersion) {
        return serverVersion.getMajor() >= 3 && serverVersion.getMinor() >= 8;
    }
}

