/*
 * Decompiled with CFR 0.152.
 */
package com.shinyhut.vernacular.protocol.handshaking;

import com.shinyhut.vernacular.client.VncSession;
import com.shinyhut.vernacular.client.exceptions.AuthenticationFailedException;
import com.shinyhut.vernacular.client.exceptions.VncException;
import com.shinyhut.vernacular.protocol.auth.SecurityHandler;
import com.shinyhut.vernacular.protocol.handshaking.ProtocolVersionNegotiator;
import com.shinyhut.vernacular.protocol.handshaking.SecurityTypeNegotiator;
import com.shinyhut.vernacular.protocol.messages.SecurityResult;
import java.io.IOException;

public class Handshaker {
    private final ProtocolVersionNegotiator protocolVersionNegotiator = new ProtocolVersionNegotiator();
    private final SecurityTypeNegotiator securityTypeNegotiator = new SecurityTypeNegotiator();

    public void handshake(VncSession session) throws VncException, IOException {
        this.protocolVersionNegotiator.negotiate(session);
        SecurityHandler securityHandler = this.securityTypeNegotiator.negotiate(session);
        securityHandler.authenticate(session);
        SecurityResult securityResult = SecurityResult.decode(session.getInputStream());
        if (!securityResult.isSuccess()) {
            throw new AuthenticationFailedException(securityResult.getErrorMessage());
        }
    }
}

