/*
 * Decompiled with CFR 0.152.
 */
package com.shinyhut.vernacular.protocol.auth;

import com.shinyhut.vernacular.client.VncSession;
import com.shinyhut.vernacular.client.exceptions.AuthenticationRequiredException;
import com.shinyhut.vernacular.client.exceptions.UnexpectedVncException;
import com.shinyhut.vernacular.client.exceptions.VncException;
import com.shinyhut.vernacular.protocol.auth.SecurityHandler;
import com.shinyhut.vernacular.utils.ByteUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.function.Supplier;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class VncAuthenticationHandler
implements SecurityHandler {
    private static final byte VNC_AUTHENTICATION_TYPE = 2;

    @Override
    public void authenticate(VncSession session) throws VncException, IOException {
        Supplier<String> passwordSupplier = session.getConfig().getPasswordSupplier();
        if (passwordSupplier == null) {
            throw new AuthenticationRequiredException();
        }
        InputStream in = session.getInputStream();
        OutputStream out = session.getOutputStream();
        try {
            VncAuthenticationHandler.requestVncAuthentication(out);
            byte[] challenge = VncAuthenticationHandler.readChallenge(in);
            VncAuthenticationHandler.sendResponse(out, challenge, passwordSupplier.get());
        }
        catch (GeneralSecurityException e) {
            throw new UnexpectedVncException(e);
        }
    }

    private static void requestVncAuthentication(OutputStream out) throws IOException {
        out.write(2);
    }

    private static byte[] readChallenge(InputStream in) throws IOException {
        DataInputStream data = new DataInputStream(in);
        byte[] challenge = new byte[16];
        data.readFully(challenge);
        return challenge;
    }

    private static void sendResponse(OutputStream out, byte[] challenge, String password) throws IOException, GeneralSecurityException {
        Cipher des = Cipher.getInstance("DES/ECB/NoPadding");
        des.init(1, VncAuthenticationHandler.buildKey(password));
        out.write(des.doFinal(challenge));
    }

    private static SecretKeySpec buildKey(String password) {
        byte[] key = VncAuthenticationHandler.keyBytes(password);
        return new SecretKeySpec(key, 0, key.length, "DES");
    }

    private static byte[] keyBytes(String password) {
        byte[] key;
        byte[] passwordBytes;
        System.arraycopy(passwordBytes, 0, key, 0, (passwordBytes = password.getBytes(Charset.forName("US-ASCII"))).length < (key = new byte[8]).length ? passwordBytes.length : key.length);
        return ByteUtils.reverseBits(key);
    }
}

