/*
 * Decompiled with CFR 0.152.
 */
package com.shinyhut.vernacular.client.rendering.renderers;

import com.shinyhut.vernacular.client.rendering.renderers.Pixel;
import com.shinyhut.vernacular.client.rendering.renderers.PixelDecoder;
import com.shinyhut.vernacular.client.rendering.renderers.Renderer;
import com.shinyhut.vernacular.protocol.messages.PixelFormat;
import com.shinyhut.vernacular.protocol.messages.Rectangle;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class RawRenderer
implements Renderer {
    private final PixelDecoder pixelDecoder;
    private final PixelFormat pixelFormat;

    public RawRenderer(PixelDecoder pixelDecoder, PixelFormat pixelFormat) {
        this.pixelDecoder = pixelDecoder;
        this.pixelFormat = pixelFormat;
    }

    @Override
    public void render(BufferedImage destination, Rectangle rectangle) {
        this.render(destination, rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getPixelData());
    }

    public void render(BufferedImage destination, int x, int y, int width, byte[] pixelData) {
        int sx = x;
        int sy = y;
        for (int i = 0; i <= pixelData.length - this.pixelFormat.getBytesPerPixel(); i += this.pixelFormat.getBytesPerPixel()) {
            byte[] bytes = new byte[this.pixelFormat.getBytesPerPixel()];
            System.arraycopy(pixelData, i, bytes, 0, bytes.length);
            Pixel pixel = this.pixelDecoder.decode(bytes, this.pixelFormat);
            destination.setRGB(sx, sy, new Color(pixel.getRed(), pixel.getGreen(), pixel.getBlue()).getRGB());
            if (++sx != x + width) continue;
            sx = x;
            ++sy;
        }
    }
}

