/*
 * Decompiled with CFR 0.152.
 */
package com.shinyhut.vernacular.client.rendering.renderers;

import com.shinyhut.vernacular.client.exceptions.UnexpectedVncException;
import com.shinyhut.vernacular.client.exceptions.VncException;
import com.shinyhut.vernacular.client.rendering.renderers.Pixel;
import com.shinyhut.vernacular.client.rendering.renderers.PixelDecoder;
import com.shinyhut.vernacular.client.rendering.renderers.Renderer;
import com.shinyhut.vernacular.protocol.messages.PixelFormat;
import com.shinyhut.vernacular.protocol.messages.Rectangle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class RRERenderer
implements Renderer {
    private final PixelDecoder pixelDecoder;
    private final PixelFormat pixelFormat;

    public RRERenderer(PixelDecoder pixelDecoder, PixelFormat pixelFormat) {
        this.pixelDecoder = pixelDecoder;
        this.pixelFormat = pixelFormat;
    }

    @Override
    public void render(BufferedImage destination, Rectangle rectangle) throws VncException {
        byte[] pixelData = rectangle.getPixelData();
        DataInputStream dataInput = new DataInputStream(new ByteArrayInputStream(pixelData));
        try {
            int numberOfSubrectangles = dataInput.readInt();
            byte[] bgColorBytes = new byte[this.pixelFormat.getBytesPerPixel()];
            dataInput.readFully(bgColorBytes);
            Pixel bgColor = this.pixelDecoder.decode(bgColorBytes, this.pixelFormat);
            Graphics2D graphic = (Graphics2D)destination.getGraphics();
            graphic.setColor(new Color(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue()));
            graphic.fillRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
            for (int i = 0; i < numberOfSubrectangles; ++i) {
                byte[] bytes = new byte[this.pixelFormat.getBytesPerPixel()];
                dataInput.readFully(bytes);
                int x = dataInput.readUnsignedShort();
                int y = dataInput.readUnsignedShort();
                int width = dataInput.readUnsignedShort();
                int height = dataInput.readUnsignedShort();
                Pixel color = this.pixelDecoder.decode(bytes, this.pixelFormat);
                graphic.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue()));
                graphic.fillRect(x + rectangle.getX(), y + rectangle.getY(), width, height);
            }
        }
        catch (IOException e) {
            throw new UnexpectedVncException(e);
        }
    }
}

