/*
 * Decompiled with CFR 0.152.
 */
package com.shinyhut.vernacular.client.rendering.renderers;

import com.shinyhut.vernacular.client.rendering.renderers.Pixel;
import com.shinyhut.vernacular.protocol.messages.ColorMapEntry;
import com.shinyhut.vernacular.protocol.messages.PixelFormat;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Map;
import java.util.Optional;

public class PixelDecoder {
    private static final ColorMapEntry BLACK = new ColorMapEntry(0, 0, 0);
    private final Map<BigInteger, ColorMapEntry> colorMap;

    public PixelDecoder(Map<BigInteger, ColorMapEntry> colorMap) {
        this.colorMap = colorMap;
    }

    public Pixel decode(InputStream in, PixelFormat pixelFormat) throws IOException {
        DataInputStream dataInput = new DataInputStream(in);
        byte[] bytes = new byte[pixelFormat.getBytesPerPixel()];
        dataInput.readFully(bytes);
        return this.decode(bytes, pixelFormat);
    }

    public Pixel decode(byte[] bytes, PixelFormat pixelFormat) {
        int blue;
        int green;
        int red;
        BigInteger value = new BigInteger(1, bytes);
        if (pixelFormat.isTrueColor()) {
            red = value.shiftRight(pixelFormat.getRedShift()).intValue() & pixelFormat.getRedMax();
            green = value.shiftRight(pixelFormat.getGreenShift()).intValue() & pixelFormat.getGreenMax();
            blue = value.shiftRight(pixelFormat.getBlueShift()).intValue() & pixelFormat.getBlueMax();
            red = PixelDecoder.stretch(red, pixelFormat.getRedMax());
            green = PixelDecoder.stretch(green, pixelFormat.getGreenMax());
            blue = PixelDecoder.stretch(blue, pixelFormat.getBlueMax());
        } else {
            ColorMapEntry color = Optional.ofNullable(this.colorMap.get(value)).orElse(BLACK);
            red = PixelDecoder.shrink(color.getRed());
            green = PixelDecoder.shrink(color.getGreen());
            blue = PixelDecoder.shrink(color.getBlue());
        }
        return new Pixel(red, green, blue);
    }

    private static int stretch(int value, int max) {
        return (int)((double)value * (255.0 / (double)max));
    }

    private static int shrink(int colorMapValue) {
        return (int)Math.round((double)colorMapValue / 257.0);
    }
}

