/*
 * Decompiled with CFR 0.152.
 */
package com.shinyhut.vernacular.client.rendering.renderers;

import com.shinyhut.vernacular.client.exceptions.UnexpectedVncException;
import com.shinyhut.vernacular.client.exceptions.VncException;
import com.shinyhut.vernacular.client.rendering.renderers.Pixel;
import com.shinyhut.vernacular.client.rendering.renderers.PixelDecoder;
import com.shinyhut.vernacular.client.rendering.renderers.RawRenderer;
import com.shinyhut.vernacular.client.rendering.renderers.Renderer;
import com.shinyhut.vernacular.protocol.messages.PixelFormat;
import com.shinyhut.vernacular.protocol.messages.Rectangle;
import com.shinyhut.vernacular.utils.ByteUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;

public class HextileRenderer
implements Renderer {
    public static final int SUB_ENCODING_MASK_RAW = 1;
    public static final int SUB_ENCODING_MASK_BACKGROUND_SPECIFIED = 2;
    public static final int SUB_ENCODING_MASK_FOREGROUND_SPECIFIED = 4;
    public static final int SUB_ENCODING_MASK_ANY_SUBRECTS = 8;
    public static final int SUB_ENCODING_MASK_SUBRECTS_COLORED = 16;
    private static final int TILE_SIZE = 16;
    private final RawRenderer rawRenderer;
    private final PixelDecoder pixelDecoder;
    private final PixelFormat pixelFormat;

    public HextileRenderer(RawRenderer rawRenderer, PixelDecoder pixelDecoder, PixelFormat pixelFormat) {
        this.pixelDecoder = pixelDecoder;
        this.rawRenderer = rawRenderer;
        this.pixelFormat = pixelFormat;
    }

    @Override
    public void render(BufferedImage destination, Rectangle rectangle) throws VncException {
        ByteArrayInputStream in = new ByteArrayInputStream(rectangle.getPixelData());
        DataInputStream dataInput = new DataInputStream(in);
        Graphics2D graphics = (Graphics2D)destination.getGraphics();
        int horizontalTiles = (int)Math.ceil((double)rectangle.getWidth() / 16.0);
        int verticalTiles = (int)Math.ceil((double)rectangle.getHeight() / 16.0);
        Pixel lastBackground = null;
        Pixel lastForeground = null;
        for (int ty = 0; ty < verticalTiles; ++ty) {
            for (int tx = 0; tx < horizontalTiles; ++tx) {
                try {
                    int sx = rectangle.getX() + tx * 16;
                    int sy = rectangle.getY() + ty * 16;
                    int width = HextileRenderer.tileSize(tx, horizontalTiles, rectangle.getWidth());
                    int height = HextileRenderer.tileSize(ty, verticalTiles, rectangle.getHeight());
                    int subencoding = dataInput.readUnsignedByte();
                    boolean raw = ByteUtils.mask(subencoding, 1);
                    if (raw) {
                        this.drawRawTile(destination, dataInput, sx, sy, width, height);
                        continue;
                    }
                    Pixel background = this.backgroundColor(in, subencoding).orElse(lastBackground);
                    Pixel foreground = this.foregroundColor(in, subencoding).orElse(lastForeground);
                    lastBackground = background;
                    lastForeground = foreground;
                    this.fillRect(graphics, sx, sy, width, height, background);
                    boolean anySubrects = ByteUtils.mask(subencoding, 8);
                    if (!anySubrects) continue;
                    int subrectCount = dataInput.readUnsignedByte();
                    for (int s = 0; s < subrectCount; ++s) {
                        this.renderSubrectangle(in, dataInput, graphics, sx, sy, subencoding, foreground);
                    }
                    continue;
                }
                catch (IOException e) {
                    throw new UnexpectedVncException(e);
                }
            }
        }
    }

    public static int tileSize(int tileNo, int tileCount, int rectangleSize) {
        return tileNo == tileCount - 1 && rectangleSize % 16 != 0 ? rectangleSize % 16 : 16;
    }

    private void drawRawTile(BufferedImage img, DataInput in, int x, int y, int width, int height) throws IOException {
        byte[] pixelData = new byte[width * height * this.pixelFormat.getBytesPerPixel()];
        in.readFully(pixelData);
        this.rawRenderer.render(img, x, y, width, pixelData);
    }

    private void renderSubrectangle(InputStream in, DataInput dataInput, Graphics2D graphics, int x, int y, int subencoding, Pixel foreground) throws IOException {
        Pixel color = this.subrectangleColor(in, subencoding).orElse(foreground);
        int coords = dataInput.readUnsignedByte();
        int dimensions = dataInput.readUnsignedByte();
        int subrectX = coords >> 4;
        int subrectY = coords & 0xF;
        int width = (dimensions >> 4) + 1;
        int height = (dimensions & 0xF) + 1;
        int sx = x + subrectX;
        int sy = y + subrectY;
        this.fillRect(graphics, sx, sy, width, height, color);
    }

    private void fillRect(Graphics2D g, int x, int y, int width, int height, Pixel color) {
        g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue()));
        g.fillRect(x, y, width, height);
    }

    private Optional<Pixel> backgroundColor(InputStream in, int subencoding) throws IOException {
        return this.optionalPixel(in, subencoding, 2);
    }

    private Optional<Pixel> foregroundColor(InputStream in, int subencoding) throws IOException {
        return this.optionalPixel(in, subencoding, 4);
    }

    private Optional<Pixel> subrectangleColor(InputStream in, int subencoding) throws IOException {
        return this.optionalPixel(in, subencoding, 16);
    }

    private Optional<Pixel> optionalPixel(InputStream in, int subencoding, int mask) throws IOException {
        Optional<Pixel> pixel = ByteUtils.mask(subencoding, mask) ? Optional.of(this.pixelDecoder.decode(in, this.pixelFormat)) : Optional.empty();
        return pixel;
    }
}

