/*
 * Decompiled with CFR 0.152.
 */
package com.shinyhut.vernacular.client.rendering.renderers;

import com.shinyhut.vernacular.client.exceptions.UnexpectedVncException;
import com.shinyhut.vernacular.client.exceptions.VncException;
import com.shinyhut.vernacular.client.rendering.renderers.Renderer;
import com.shinyhut.vernacular.protocol.messages.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class CopyRectRenderer
implements Renderer {
    @Override
    public void render(BufferedImage destination, Rectangle rectangle) throws VncException {
        try {
            DataInputStream dataInput = new DataInputStream(new ByteArrayInputStream(rectangle.getPixelData()));
            int srcX = dataInput.readUnsignedShort();
            int srcY = dataInput.readUnsignedShort();
            BufferedImage src = new BufferedImage(rectangle.getWidth(), rectangle.getHeight(), 1);
            destination.getSubimage(srcX, srcY, rectangle.getWidth(), rectangle.getHeight()).copyData(src.getRaster());
            destination.getGraphics().drawImage(src, rectangle.getX(), rectangle.getY(), null);
        }
        catch (IOException e) {
            throw new UnexpectedVncException(e);
        }
    }
}

