/*
 * Decompiled with CFR 0.152.
 */
package com.shinyhut.vernacular.client.rendering;

import com.shinyhut.vernacular.client.VncSession;
import com.shinyhut.vernacular.client.exceptions.VncException;
import com.shinyhut.vernacular.client.rendering.renderers.CopyRectRenderer;
import com.shinyhut.vernacular.client.rendering.renderers.HextileRenderer;
import com.shinyhut.vernacular.client.rendering.renderers.PixelDecoder;
import com.shinyhut.vernacular.client.rendering.renderers.RRERenderer;
import com.shinyhut.vernacular.client.rendering.renderers.RawRenderer;
import com.shinyhut.vernacular.client.rendering.renderers.Renderer;
import com.shinyhut.vernacular.protocol.messages.ColorMapEntry;
import com.shinyhut.vernacular.protocol.messages.Encoding;
import com.shinyhut.vernacular.protocol.messages.FramebufferUpdate;
import com.shinyhut.vernacular.protocol.messages.Rectangle;
import com.shinyhut.vernacular.protocol.messages.SetColorMapEntries;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class Framebuffer {
    private final VncSession session;
    private final Map<BigInteger, ColorMapEntry> colorMap = new ConcurrentHashMap<BigInteger, ColorMapEntry>();
    private final Map<Encoding, Renderer> renderers = new ConcurrentHashMap<Encoding, Renderer>();
    private BufferedImage frame;

    public Framebuffer(VncSession session) {
        PixelDecoder pixelDecoder = new PixelDecoder(this.colorMap);
        RawRenderer rawRenderer = new RawRenderer(pixelDecoder, session.getPixelFormat());
        this.renderers.put(Encoding.RAW, rawRenderer);
        this.renderers.put(Encoding.COPYRECT, new CopyRectRenderer());
        this.renderers.put(Encoding.RRE, new RRERenderer(pixelDecoder, session.getPixelFormat()));
        this.renderers.put(Encoding.HEXTILE, new HextileRenderer(rawRenderer, pixelDecoder, session.getPixelFormat()));
        this.frame = new BufferedImage(session.getFramebufferWidth(), session.getFramebufferHeight(), 1);
        this.frame.setAccelerationPriority(1.0f);
        this.session = session;
    }

    public void processUpdate(FramebufferUpdate update) throws VncException {
        this.session.setLastFramebufferUpdateTime(LocalDateTime.now());
        for (Rectangle rectangle : update.getRectangles()) {
            if (rectangle.getEncoding() == Encoding.DESKTOP_SIZE) {
                this.resizeFramebuffer(rectangle);
                continue;
            }
            this.renderers.get((Object)rectangle.getEncoding()).render(this.frame, rectangle);
        }
        this.paint();
    }

    private void paint() {
        Consumer<Image> listener = this.session.getConfig().getScreenUpdateListener();
        if (listener != null) {
            listener.accept(this.frame);
        }
    }

    public void updateColorMap(SetColorMapEntries update) {
        for (int i = 0; i < update.getColors().size(); ++i) {
            this.colorMap.put(BigInteger.valueOf(i + update.getFirstColor()), update.getColors().get(i));
        }
    }

    private void resizeFramebuffer(Rectangle newSize) {
        int width = newSize.getWidth();
        int height = newSize.getHeight();
        this.session.setFramebufferWidth(width);
        this.session.setFramebufferHeight(height);
        BufferedImage resized = new BufferedImage(width, height, 1);
        resized.getGraphics().drawImage(this.frame, 0, 0, null);
        this.frame = resized;
    }
}

