/*
 * Decompiled with CFR 0.152.
 */
package com.shinyhut.vernacular.client.exceptions;

import com.shinyhut.vernacular.client.exceptions.VncException;

public class UnsupportedProtocolVersionException
extends VncException {
    private final int serverMajor;
    private final int serverMinor;
    private final int requiredMajor;
    private final int requiredMinor;

    public UnsupportedProtocolVersionException(int serverMajor, int serverMinor, int minMajor, int minMinor) {
        super(String.format("The server supports protocol version %d.%d. We require version %d.%d", serverMajor, serverMinor, minMajor, minMinor));
        this.serverMajor = serverMajor;
        this.serverMinor = serverMinor;
        this.requiredMajor = minMajor;
        this.requiredMinor = minMinor;
    }

    public int getServerMajor() {
        return this.serverMajor;
    }

    public int getServerMinor() {
        return this.serverMinor;
    }

    public int getRequiredMajor() {
        return this.requiredMajor;
    }

    public int getRequiredMinor() {
        return this.requiredMinor;
    }
}

