/*
 * Decompiled with CFR 0.152.
 */
package com.shinyhut.vernacular.client;

import com.shinyhut.vernacular.client.VernacularConfig;
import com.shinyhut.vernacular.protocol.messages.PixelFormat;
import com.shinyhut.vernacular.protocol.messages.ServerInit;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.Optional;

public class VncSession {
    private final String host;
    private final int port;
    private final VernacularConfig config;
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private ServerInit serverInit;
    private PixelFormat pixelFormat;
    private int framebufferWidth;
    private int framebufferHeight;
    private LocalDateTime lastFramebufferUpdateTime;
    private LocalDateTime lastFramebufferUpdateRequestTime;

    public VncSession(String host, int port, VernacularConfig config, InputStream inputStream, OutputStream outputStream) {
        this.host = host;
        this.port = port;
        this.config = config;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public VernacularConfig getConfig() {
        return this.config;
    }

    public ServerInit getServerInit() {
        return this.serverInit;
    }

    public void setServerInit(ServerInit serverInit) {
        this.serverInit = serverInit;
    }

    public PixelFormat getPixelFormat() {
        return this.pixelFormat;
    }

    public void setPixelFormat(PixelFormat pixelFormat) {
        this.pixelFormat = pixelFormat;
    }

    public Optional<LocalDateTime> getLastFramebufferUpdateTime() {
        return Optional.ofNullable(this.lastFramebufferUpdateTime);
    }

    public void setLastFramebufferUpdateTime(LocalDateTime lastFramebufferUpdateTime) {
        this.lastFramebufferUpdateTime = lastFramebufferUpdateTime;
    }

    public Optional<LocalDateTime> getLastFramebufferUpdateRequestTime() {
        return Optional.ofNullable(this.lastFramebufferUpdateRequestTime);
    }

    public void setLastFramebufferUpdateRequestTime(LocalDateTime lastFramebufferUpdateRequestTime) {
        this.lastFramebufferUpdateRequestTime = lastFramebufferUpdateRequestTime;
    }

    public int getFramebufferWidth() {
        return this.framebufferWidth;
    }

    public void setFramebufferWidth(int framebufferWidth) {
        this.framebufferWidth = framebufferWidth;
    }

    public int getFramebufferHeight() {
        return this.framebufferHeight;
    }

    public void setFramebufferHeight(int framebufferHeight) {
        this.framebufferHeight = framebufferHeight;
    }

    public void kill() {
        try {
            this.inputStream.close();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

