/*
 * Decompiled with CFR 0.152.
 */
package com.shinyhut.vernacular.client;

import com.shinyhut.vernacular.client.ClientEventHandler;
import com.shinyhut.vernacular.client.ServerEventHandler;
import com.shinyhut.vernacular.client.VernacularConfig;
import com.shinyhut.vernacular.client.VncSession;
import com.shinyhut.vernacular.client.exceptions.UnexpectedVncException;
import com.shinyhut.vernacular.client.exceptions.VncException;
import com.shinyhut.vernacular.protocol.handshaking.Handshaker;
import com.shinyhut.vernacular.protocol.initialization.Initializer;
import com.shinyhut.vernacular.utils.KeySyms;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.stream.IntStream;

public class VernacularClient {
    private final Handshaker handshaker;
    private final Initializer initializer;
    private final VernacularConfig config;
    private VncSession session;
    private ClientEventHandler clientEventHandler;
    private ServerEventHandler serverEventHandler;
    private volatile boolean running;

    public VernacularClient(VernacularConfig config) {
        this.config = config;
        this.handshaker = new Handshaker();
        this.initializer = new Initializer();
    }

    public void start(String host, int port) {
        if (this.running) {
            throw new IllegalStateException("VNC Client is already running");
        }
        this.running = true;
        try {
            this.createSession(host, port);
            this.clientEventHandler = new ClientEventHandler(this.session, this::handleError);
            this.serverEventHandler = new ServerEventHandler(this.session, this::handleError);
            this.serverEventHandler.start();
            this.clientEventHandler.start();
        }
        catch (IOException e) {
            this.handleError(new UnexpectedVncException(e));
        }
        catch (VncException e) {
            this.handleError(e);
        }
    }

    public void stop() {
        this.running = false;
        if (this.serverEventHandler != null) {
            this.serverEventHandler.stop();
        }
        if (this.clientEventHandler != null) {
            this.clientEventHandler.stop();
        }
        if (this.session != null) {
            this.session.kill();
        }
    }

    public void moveMouse(int x, int y) {
        if (this.clientEventHandler != null) {
            try {
                this.clientEventHandler.moveMouse(x, y);
            }
            catch (IOException e) {
                this.handleError(new UnexpectedVncException(e));
            }
        }
    }

    public void updateMouseButton(int button, boolean pressed) {
        if (this.clientEventHandler != null) {
            try {
                this.clientEventHandler.updateMouseButton(button, pressed);
            }
            catch (IOException e) {
                this.handleError(new UnexpectedVncException(e));
            }
        }
    }

    public void click(int button) {
        this.updateMouseButton(button, true);
        this.updateMouseButton(button, false);
    }

    @Deprecated
    public void keyPress(KeyEvent event) {
        if (event.getID() == 401 || event.getID() == 402) {
            KeySyms.forEvent(event).ifPresent(k -> this.keyPress((int)k, event.getID() == 401));
        }
    }

    public void handleKeyEvent(KeyEvent event) {
        KeySyms.forEvent(event).ifPresent(k -> {
            switch (event.getID()) {
                case 401: 
                case 402: {
                    this.updateKey((int)k, event.getID() == 401);
                    break;
                }
                case 400: {
                    this.type((int)k);
                }
            }
        });
    }

    @Deprecated
    public void keyPress(int keySym, boolean pressed) {
        this.updateKey(keySym, pressed);
    }

    public void updateKey(int keySym, boolean pressed) {
        if (this.clientEventHandler != null) {
            try {
                this.clientEventHandler.updateKey(keySym, pressed);
            }
            catch (IOException e) {
                this.handleError(new UnexpectedVncException(e));
            }
        }
    }

    public void type(int keySym) {
        this.updateKey(keySym, true);
        this.updateKey(keySym, false);
    }

    public void type(String text) {
        text = text.replaceAll("\r\n", "\n").replaceAll("\r", "\n");
        IntStream.range(0, text.length()).map(text::charAt).map(c -> {
            switch (c) {
                case 10: {
                    return KeySyms.forKeyCode(10).get();
                }
                case 9: {
                    return KeySyms.forKeyCode(9).get();
                }
            }
            return c;
        }).forEach(this::type);
    }

    public void copyText(String text) {
        if (this.clientEventHandler != null) {
            try {
                this.clientEventHandler.copyText(text);
            }
            catch (IOException e) {
                this.handleError(new UnexpectedVncException(e));
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    private void createSession(String host, int port) throws IOException, VncException {
        Socket socket = new Socket(host, port);
        InputStream in = socket.getInputStream();
        OutputStream out = socket.getOutputStream();
        this.session = new VncSession(host, port, this.config, in, out);
        this.handshaker.handshake(this.session);
        this.initializer.initialise(this.session);
    }

    private void handleError(VncException e) {
        this.notifyErrorListeners(e);
        this.stop();
    }

    private void notifyErrorListeners(VncException e) {
        if (this.config.getErrorListener() != null) {
            this.config.getErrorListener().accept(e);
        }
    }
}

