/*
 * Decompiled with CFR 0.152.
 */
package com.shinyhut.vernacular.client;

import com.shinyhut.vernacular.client.VncSession;
import com.shinyhut.vernacular.client.exceptions.UnexpectedVncException;
import com.shinyhut.vernacular.client.exceptions.UnknownMessageTypeException;
import com.shinyhut.vernacular.client.exceptions.VncException;
import com.shinyhut.vernacular.client.rendering.Framebuffer;
import com.shinyhut.vernacular.protocol.messages.Bell;
import com.shinyhut.vernacular.protocol.messages.FramebufferUpdate;
import com.shinyhut.vernacular.protocol.messages.ServerCutText;
import com.shinyhut.vernacular.protocol.messages.SetColorMapEntries;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.function.Consumer;

public class ServerEventHandler {
    private final VncSession session;
    private final Consumer<VncException> errorHandler;
    private final Framebuffer framebuffer;
    private volatile boolean running;
    private Thread eventLoop;

    ServerEventHandler(VncSession session, Consumer<VncException> errorHandler) {
        this.session = session;
        this.errorHandler = errorHandler;
        this.framebuffer = new Framebuffer(session);
    }

    void start() {
        PushbackInputStream in = new PushbackInputStream(this.session.getInputStream());
        this.running = true;
        this.eventLoop = new Thread(() -> {
            try {
                int messageType;
                block13: while (this.running && (messageType = in.read()) != -1) {
                    in.unread(messageType);
                    switch (messageType) {
                        case 0: {
                            FramebufferUpdate framebufferUpdate = FramebufferUpdate.decode(in, this.session.getPixelFormat().getBitsPerPixel());
                            this.framebuffer.processUpdate(framebufferUpdate);
                            continue block13;
                        }
                        case 1: {
                            SetColorMapEntries setColorMapEntries = SetColorMapEntries.decode(in);
                            this.framebuffer.updateColorMap(setColorMapEntries);
                            continue block13;
                        }
                        case 2: {
                            Bell.decode(in);
                            Consumer<Void> bellListener = this.session.getConfig().getBellListener();
                            if (bellListener == null) continue block13;
                            bellListener.accept(null);
                            continue block13;
                        }
                        case 3: {
                            ServerCutText cutText = ServerCutText.decode(in);
                            Consumer<String> cutTextListener = this.session.getConfig().getServerCutTextListener();
                            if (cutTextListener == null) continue block13;
                            cutTextListener.accept(cutText.getText());
                            continue block13;
                        }
                    }
                    throw new UnknownMessageTypeException(messageType);
                }
            }
            catch (IOException e) {
                if (this.running) {
                    this.errorHandler.accept(new UnexpectedVncException(e));
                }
            }
            catch (VncException e) {
                if (this.running) {
                    this.errorHandler.accept(e);
                }
            }
            finally {
                this.running = false;
            }
        });
        this.eventLoop.start();
    }

    void stop() {
        this.running = false;
        try {
            if (this.eventLoop != null) {
                this.eventLoop.join(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

