/*
 * Decompiled with CFR 0.152.
 */
package com.shinyhut.vernacular.client;

import com.shinyhut.vernacular.client.VncSession;
import com.shinyhut.vernacular.client.exceptions.UnexpectedVncException;
import com.shinyhut.vernacular.client.exceptions.VncException;
import com.shinyhut.vernacular.protocol.messages.ClientCutText;
import com.shinyhut.vernacular.protocol.messages.Encodable;
import com.shinyhut.vernacular.protocol.messages.FramebufferUpdateRequest;
import com.shinyhut.vernacular.protocol.messages.KeyEvent;
import com.shinyhut.vernacular.protocol.messages.PointerEvent;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.IntStream;

public class ClientEventHandler {
    private final VncSession session;
    private final Consumer<VncException> errorHandler;
    private final List<Boolean> buttons = Collections.synchronizedList(new ArrayList());
    private final ReentrantLock outputLock = new ReentrantLock(true);
    private volatile boolean running;
    private Thread eventLoop;
    private int mouseX;
    private int mouseY;

    ClientEventHandler(VncSession session, Consumer<VncException> errorHandler) {
        this.session = session;
        this.errorHandler = errorHandler;
        IntStream.range(0, 8).forEach(i -> this.buttons.add(false));
    }

    void start() {
        this.running = true;
        this.eventLoop = new Thread(() -> {
            try {
                while (this.running) {
                    if (this.timeForFramebufferUpdate()) {
                        this.requestFramebufferUpdate();
                    }
                    this.pause();
                }
            }
            catch (IOException e) {
                if (this.running) {
                    this.errorHandler.accept(new UnexpectedVncException(e));
                }
            }
            finally {
                this.running = false;
            }
        });
        this.eventLoop.start();
    }

    void stop() {
        this.running = false;
        try {
            if (this.eventLoop != null) {
                this.eventLoop.join(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void updateMouseButton(int button, boolean pressed) throws IOException {
        this.buttons.set(button, pressed);
        this.updateMouseStatus();
    }

    void moveMouse(int mouseX, int mouseY) throws IOException {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.updateMouseStatus();
    }

    void updateKey(int keySym, boolean pressed) throws IOException {
        KeyEvent message = new KeyEvent(keySym, pressed);
        this.sendMessage(message);
    }

    void copyText(String text) throws IOException {
        ClientCutText message = new ClientCutText(text);
        this.sendMessage(message);
    }

    private void updateMouseStatus() throws IOException {
        PointerEvent message = new PointerEvent(this.mouseX, this.mouseY, this.buttons);
        this.sendMessage(message);
    }

    private boolean timeForFramebufferUpdate() {
        long updateInterval = 1000 / this.session.getConfig().getTargetFramesPerSecond();
        return this.session.getLastFramebufferUpdateRequestTime().map(lastUpdate -> LocalDateTime.now().isAfter(lastUpdate.plus(updateInterval, ChronoUnit.MILLIS))).orElse(true);
    }

    private void requestFramebufferUpdate() throws IOException {
        boolean firstRun;
        boolean incremental = this.session.getLastFramebufferUpdateTime().isPresent();
        boolean bl = firstRun = !this.session.getLastFramebufferUpdateRequestTime().isPresent();
        if (firstRun || incremental) {
            this.session.setLastFramebufferUpdateRequestTime(LocalDateTime.now());
            int width = this.session.getFramebufferWidth();
            int height = this.session.getFramebufferHeight();
            FramebufferUpdateRequest updateRequest = new FramebufferUpdateRequest(incremental, 0, 0, width, height);
            this.sendMessage(updateRequest);
        }
    }

    private void sendMessage(Encodable message) throws IOException {
        this.outputLock.lock();
        try {
            message.encode(this.session.getOutputStream());
        }
        finally {
            this.outputLock.unlock();
        }
    }

    private void pause() {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

