/*
 * Decompiled with CFR 0.152.
 */
package com.shinyhut.vernacular;

import com.shinyhut.vernacular.client.VernacularClient;
import com.shinyhut.vernacular.client.VernacularConfig;
import com.shinyhut.vernacular.client.rendering.ColorDepth;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class VernacularViewer
extends JFrame {
    private VernacularConfig config;
    private VernacularClient client;
    private JMenuItem connectMenuItem;
    private JMenuItem disconnectMenuItem;
    private JMenuItem bpp8IndexedColorMenuItem;
    private JMenuItem bpp16TrueColorMenuItem;
    private Image lastFrame;
    private AncestorListener focusRequester = new AncestorListener(){

        @Override
        public void ancestorAdded(AncestorEvent event) {
            event.getComponent().requestFocusInWindow();
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    };
    private volatile boolean shutdown = false;
    private Thread clipboardMonitor = new Thread(() -> {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        String lastText = null;
        while (!this.shutdown) {
            try {
                String text;
                if (this.connected() && (text = (String)clipboard.getData(DataFlavor.stringFlavor)) != null && !text.equals(lastText)) {
                    this.client.copyText(text);
                    lastText = text;
                }
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    });

    private VernacularViewer() {
        this.initUI();
    }

    private void initUI() {
        this.setTitle("Vernacular VNC");
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                VernacularViewer.this.disconnect();
                VernacularViewer.this.shutdown = true;
                try {
                    VernacularViewer.this.clipboardMonitor.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                super.windowClosing(event);
            }
        });
        this.addMenu();
        this.addMouseListeners();
        this.addKeyListener();
        this.addDrawingSurface();
        this.initialiseVernacularClient();
        this.clipboardMonitor.start();
    }

    private void addKeyListener() {
        this.setFocusTraversalKeysEnabled(false);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (VernacularViewer.this.connected()) {
                    VernacularViewer.this.client.handleKeyEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (VernacularViewer.this.connected()) {
                    VernacularViewer.this.client.handleKeyEvent(e);
                }
            }
        });
    }

    private void addMouseListeners() {
        this.getContentPane().addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                this.mouseMoved(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (VernacularViewer.this.connected()) {
                    VernacularViewer.this.client.moveMouse(VernacularViewer.this.scaleMouseX(e.getX()), VernacularViewer.this.scaleMouseY(e.getY()));
                }
            }
        });
        this.getContentPane().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (VernacularViewer.this.connected()) {
                    VernacularViewer.this.client.updateMouseButton(e.getButton() - 1, true);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (VernacularViewer.this.connected()) {
                    VernacularViewer.this.client.updateMouseButton(e.getButton() - 1, false);
                }
            }
        });
    }

    private void addDrawingSurface() {
        this.add((Component)new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (VernacularViewer.this.lastFrame != null) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g2.drawImage(VernacularViewer.this.lastFrame, 0, 0, VernacularViewer.this.getContentPane().getWidth(), VernacularViewer.this.getContentPane().getHeight(), null);
                }
            }
        }, "Center");
    }

    private void initialiseVernacularClient() {
        this.config = new VernacularConfig();
        this.config.setColorDepth(ColorDepth.BPP_8_INDEXED);
        this.config.setErrorListener(e -> {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
            this.setMenuState(false);
        });
        this.config.setPasswordSupplier(this::showPasswordDialog);
        this.config.setScreenUpdateListener(this::renderFrame);
        this.config.setBellListener(v -> Toolkit.getDefaultToolkit().beep());
        this.config.setRemoteClipboardListener(t -> Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection((String)t), null));
        this.client = new VernacularClient(this.config);
    }

    private void addMenu() {
        JMenuBar menu = new JMenuBar();
        JMenu file = new JMenu("File");
        file.setMnemonic(70);
        JMenu options = new JMenu("Options");
        options.setMnemonic(79);
        this.connectMenuItem = new JMenuItem("Connect");
        this.connectMenuItem.setMnemonic(67);
        this.connectMenuItem.addActionListener(event -> this.showConnectDialog());
        this.disconnectMenuItem = new JMenuItem("Disconnect");
        this.disconnectMenuItem.setMnemonic(68);
        this.disconnectMenuItem.setEnabled(false);
        this.disconnectMenuItem.addActionListener(event -> this.disconnect());
        ButtonGroup colorDepths = new ButtonGroup();
        this.bpp8IndexedColorMenuItem = new JRadioButtonMenuItem("8-bit Indexed Color", true);
        this.bpp16TrueColorMenuItem = new JRadioButtonMenuItem("16-bit True Color");
        colorDepths.add(this.bpp8IndexedColorMenuItem);
        colorDepths.add(this.bpp16TrueColorMenuItem);
        this.bpp8IndexedColorMenuItem.addActionListener(event -> this.config.setColorDepth(ColorDepth.BPP_8_INDEXED));
        this.bpp16TrueColorMenuItem.addActionListener(event -> this.config.setColorDepth(ColorDepth.BPP_16_TRUE));
        JMenuItem exit = new JMenuItem("Exit");
        exit.setMnemonic(88);
        exit.addActionListener(event -> {
            this.disconnect();
            System.exit(0);
        });
        file.add(this.connectMenuItem);
        file.add(this.disconnectMenuItem);
        file.add(exit);
        options.add(this.bpp8IndexedColorMenuItem);
        options.add(this.bpp16TrueColorMenuItem);
        menu.add(file);
        menu.add(options);
        this.setJMenuBar(menu);
    }

    private void showConnectDialog() {
        JPanel connectDialog = new JPanel();
        JTextField hostField = new JTextField(20);
        hostField.addAncestorListener(this.focusRequester);
        JTextField portField = new JTextField("5900");
        JLabel hostLabel = new JLabel("Host");
        hostLabel.setLabelFor(hostField);
        JLabel portLabel = new JLabel("Port");
        portLabel.setLabelFor(hostLabel);
        connectDialog.add(hostLabel);
        connectDialog.add(hostField);
        connectDialog.add(portLabel);
        connectDialog.add(portField);
        int choice = JOptionPane.showConfirmDialog(this, connectDialog, "Connect", 2);
        if (choice == 0) {
            int port;
            String host = hostField.getText();
            if (host == null || host.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Please enter a valid host", null, 2);
                return;
            }
            try {
                port = Integer.parseInt(portField.getText());
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "Please enter a valid port", null, 2);
                return;
            }
            this.connect(host, port);
        }
    }

    private String showPasswordDialog() {
        String password = "";
        JPanel passwordDialog = new JPanel();
        JPasswordField passwordField = new JPasswordField(20);
        passwordField.addAncestorListener(this.focusRequester);
        passwordDialog.add(passwordField);
        int choice = JOptionPane.showConfirmDialog(this, passwordDialog, "Enter Password", 2);
        if (choice == 0) {
            password = new String(passwordField.getPassword());
        }
        return password;
    }

    private void connect(String host, int port) {
        this.setMenuState(true);
        this.lastFrame = null;
        this.client.start(host, port);
    }

    private void disconnect() {
        if (this.connected()) {
            this.client.stop();
        }
        this.setMenuState(false);
    }

    private void setMenuState(boolean running) {
        if (running) {
            this.connectMenuItem.setEnabled(false);
            this.disconnectMenuItem.setEnabled(true);
            this.bpp8IndexedColorMenuItem.setEnabled(false);
            this.bpp16TrueColorMenuItem.setEnabled(false);
        } else {
            this.connectMenuItem.setEnabled(true);
            this.disconnectMenuItem.setEnabled(false);
            this.bpp8IndexedColorMenuItem.setEnabled(true);
            this.bpp16TrueColorMenuItem.setEnabled(true);
        }
    }

    private boolean connected() {
        return this.client != null && this.client.isRunning();
    }

    private void renderFrame(Image frame) {
        if (this.resizeRequired(frame)) {
            this.resizeWindow(frame);
        }
        this.lastFrame = frame;
        this.repaint();
    }

    private boolean resizeRequired(Image frame) {
        return this.lastFrame == null || this.lastFrame.getWidth(null) != frame.getWidth(null) || this.lastFrame.getHeight(null) != frame.getHeight(null);
    }

    private void resizeWindow(Image frame) {
        int remoteWidth = frame.getWidth(null);
        int remoteHeight = frame.getHeight(null);
        Rectangle screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        int paddingTop = this.getHeight() - this.getContentPane().getHeight();
        int paddingSides = this.getWidth() - this.getContentPane().getWidth();
        int maxWidth = (int)screenSize.getWidth() - paddingSides;
        int maxHeight = (int)screenSize.getHeight() - paddingTop;
        if (remoteWidth <= maxWidth && remoteHeight < maxHeight) {
            this.setWindowSize(remoteWidth, remoteHeight);
        } else {
            double scale = Math.min((double)maxWidth / (double)remoteWidth, (double)maxHeight / (double)remoteHeight);
            int scaledWidth = (int)((double)remoteWidth * scale);
            int scaledHeight = (int)((double)remoteHeight * scale);
            this.setWindowSize(scaledWidth, scaledHeight);
        }
        this.setLocationRelativeTo(null);
    }

    private void setWindowSize(int width, int height) {
        this.getContentPane().setPreferredSize(new Dimension(width, height));
        this.pack();
    }

    private int scaleMouseX(int x) {
        if (this.lastFrame == null) {
            return x;
        }
        return (int)((double)x * ((double)this.lastFrame.getWidth(null) / (double)this.getContentPane().getWidth()));
    }

    private int scaleMouseY(int y) {
        if (this.lastFrame == null) {
            return y;
        }
        return (int)((double)y * ((double)this.lastFrame.getHeight(null) / (double)this.getContentPane().getHeight()));
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(() -> {
            VernacularViewer viewer = new VernacularViewer();
            viewer.setVisible(true);
        });
    }
}

