/*
 * Decompiled with CFR 0.152.
 */
package com.progress.progressview;

import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.progress.progressview.R;

public class ProgressView
extends View {
    private static final String PROPERTY_PROGRESS = "ProgressValue";
    private float mBackgroundWidth;
    private float mProgressWidth;
    @ColorInt
    private int mBackgroundColor;
    @ColorInt
    private int mProgressColor;
    private float mProgress = 0.0f;
    private Direction mProgressDirection = Direction.FROM_LEFT;
    private Shape mShape = Shape.ARC;
    private int mAnimationDuration = 1500;
    private int[] mGradientColorList = null;
    private Paint mBackgroundPaint;
    private Paint mProgressPaint;
    private RectF mRectF;

    public ProgressView(Context context) {
        super(context);
        this.init(context, null);
    }

    public ProgressView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ProgressView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mShape == Shape.ARC) {
            this.drawArc(canvas);
        } else if (this.mShape == Shape.CIRCLE) {
            this.drawCircle(canvas);
        } else {
            this.drawLine(canvas);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height = ProgressView.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        int width = ProgressView.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int min = Math.min(width, height);
        float highStroke = Math.max(this.mProgressWidth, this.mBackgroundWidth);
        this.mRectF.set(0.0f + highStroke / 2.0f, 0.0f + highStroke / 2.0f, (float)min - highStroke / 2.0f, (float)min - highStroke / 2.0f);
        if (this.mShape == Shape.ARC) {
            this.setMeasuredDimension(min, min / 2);
        } else if (this.mShape == Shape.CIRCLE) {
            this.setMeasuredDimension(min, min);
        } else {
            this.mRectF.set(0.0f, 0.0f + highStroke / 2.0f, (float)min, highStroke / 2.0f);
            this.setMeasuredDimension(width, (int)Math.max(highStroke, (float)height));
        }
        this.updateShader();
    }

    public void applyGradient(int[] colorList) {
        if (colorList != null) {
            this.mGradientColorList = new int[colorList.length];
            System.arraycopy(colorList, 0, this.mGradientColorList, 0, colorList.length);
        } else {
            this.mGradientColorList = null;
        }
        if (this.mGradientColorList != null && this.mProgressDirection == Direction.FROM_RIGHT) {
            ProgressView.reverse(this.mGradientColorList);
        }
        this.updateShader();
    }

    public void setProgress(float progress) {
        this.setProgressWithAnimation(progress);
    }

    public void setBackgroundWidth(float backgroundWidth) {
        this.mBackgroundWidth = backgroundWidth;
        this.mBackgroundPaint.setStrokeWidth(backgroundWidth);
        this.invalidate();
    }

    public void setProgressWidth(float progressWidth) {
        this.mProgressWidth = progressWidth;
        this.mProgressPaint.setStrokeWidth(progressWidth);
        this.invalidate();
    }

    public void setProgressDirection(Direction progressDirection) {
        if (this.mGradientColorList != null && progressDirection != this.mProgressDirection) {
            ProgressView.reverse(this.mGradientColorList);
            this.updateShader();
        }
        this.mProgressDirection = progressDirection;
        this.invalidate();
    }

    public void setAnimationDuration(int animationDuration) {
        this.mAnimationDuration = animationDuration;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.mBackgroundColor = backgroundColor;
        this.mBackgroundPaint.setColor(backgroundColor);
        this.invalidate();
    }

    public void setProgressColor(int progressColor) {
        this.mProgressColor = progressColor;
        this.mProgressPaint.setColor(progressColor);
        this.invalidate();
    }

    public float getProgress() {
        return this.mProgress;
    }

    public Direction getProgressDirection() {
        return this.mProgressDirection;
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ProgressView, 0, 0);
        int direction = typedArray.getInt(R.styleable.ProgressView_pvDirection, 0);
        this.mProgressDirection = direction == 0 ? Direction.FROM_LEFT : Direction.FROM_RIGHT;
        int shape = typedArray.getInt(R.styleable.ProgressView_pvShape, 0);
        this.mShape = shape == 0 ? Shape.ARC : (shape == 1 ? Shape.CIRCLE : Shape.LINE);
        this.mProgress = typedArray.getFloat(R.styleable.ProgressView_pvProgress, this.mProgress);
        this.mBackgroundWidth = typedArray.getDimension(R.styleable.ProgressView_pvBackgroundWidth, ProgressView.dpToPx(context, 2.0f));
        this.mProgressWidth = typedArray.getDimension(R.styleable.ProgressView_pvProgressWidth, ProgressView.dpToPx(context, 10.0f));
        this.mBackgroundColor = typedArray.getColor(R.styleable.ProgressView_pvBackgroundColor, -16777216);
        this.mProgressColor = typedArray.getColor(R.styleable.ProgressView_pvProgressColor, -65536);
        this.mAnimationDuration = typedArray.getInt(R.styleable.ProgressView_pvAnimateDuration, this.mAnimationDuration);
        typedArray.recycle();
        this.mBackgroundPaint = new Paint(1);
        this.mBackgroundPaint.setColor(this.mBackgroundColor);
        this.mBackgroundPaint.setStyle(Paint.Style.STROKE);
        this.mBackgroundPaint.setStrokeWidth(this.mBackgroundWidth);
        this.mProgressPaint = new Paint(1);
        this.mProgressPaint.setColor(this.mProgressColor);
        this.mProgressPaint.setStyle(Paint.Style.STROKE);
        this.mProgressPaint.setStrokeWidth(this.mProgressWidth);
        this.mRectF = new RectF();
    }

    private void setProgressWithAnimation(float progress) {
        PropertyValuesHolder propertyRotate = PropertyValuesHolder.ofFloat((String)PROPERTY_PROGRESS, (float[])new float[]{this.mProgress, progress});
        ValueAnimator animator = new ValueAnimator();
        animator.setValues(new PropertyValuesHolder[]{propertyRotate});
        animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animator.setDuration((long)this.mAnimationDuration);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ProgressView.this.mProgress = ((Float)animation.getAnimatedValue(ProgressView.PROPERTY_PROGRESS)).floatValue();
                ProgressView.this.invalidate();
            }
        });
        animator.start();
    }

    private void updateShader() {
        if (this.mGradientColorList == null) {
            this.mProgressPaint.setShader(null);
            this.invalidate();
            return;
        }
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        LinearGradient shader = this.mShape == Shape.ARC ? new LinearGradient(0.0f, (float)(width / 2), (float)width, (float)height, this.mGradientColorList, null, Shader.TileMode.CLAMP) : (this.mShape == Shape.CIRCLE ? new LinearGradient(0.0f, 0.0f, (float)width, (float)height, this.mGradientColorList, null, Shader.TileMode.CLAMP) : new LinearGradient(0.0f, 0.0f, (float)width, 0.0f, this.mGradientColorList, null, Shader.TileMode.CLAMP));
        this.mProgressPaint.setShader((Shader)shader);
        this.invalidate();
    }

    private void drawArc(Canvas canvas) {
        this.drawArc(canvas, 180.0f);
    }

    private void drawCircle(Canvas canvas) {
        this.drawArc(canvas, 360.0f);
    }

    private void drawLine(Canvas canvas) {
        float y = canvas.getHeight() / 2;
        canvas.drawLine(0.0f, y, (float)canvas.getWidth(), y, this.mBackgroundPaint);
        float progressWidth = this.mProgress * (float)canvas.getWidth();
        if (this.mProgressDirection == Direction.FROM_RIGHT) {
            canvas.drawLine((float)canvas.getWidth(), y, (float)canvas.getWidth() - progressWidth, y, this.mProgressPaint);
        } else {
            canvas.drawLine(0.0f, y, progressWidth, y, this.mProgressPaint);
        }
    }

    private void drawArc(Canvas canvas, float sweepAngle) {
        canvas.drawArc(this.mRectF, 180.0f, sweepAngle, false, this.mBackgroundPaint);
        float progressSweepAngle = this.mProgress * sweepAngle;
        float startAngle = 180.0f;
        if (this.mProgressDirection == Direction.FROM_RIGHT) {
            startAngle = 0.0f;
            progressSweepAngle = -progressSweepAngle;
        }
        canvas.drawArc(this.mRectF, startAngle, progressSweepAngle, false, this.mProgressPaint);
    }

    private static float dpToPx(Context context, float dp) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        return dp * ((float)metrics.densityDpi / 160.0f);
    }

    private static void reverse(int[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            int temp = array[i];
            array[i] = array[array.length - 1 - i];
            array[array.length - 1 - i] = temp;
        }
    }

    public static enum Shape {
        ARC,
        CIRCLE,
        LINE;

    }

    public static enum Direction {
        FROM_LEFT,
        FROM_RIGHT;

    }
}

