/*
 * Decompiled with CFR 0.152.
 */
package com.shimaami.kotlinprogressview;

import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import androidx.annotation.ColorInt;
import com.shimaami.kotlinprogressview.Direction;
import com.shimaami.kotlinprogressview.ProgressView$WhenMappings;
import com.shimaami.kotlinprogressview.ProgressViewKt;
import com.shimaami.kotlinprogressview.R;
import com.shimaami.kotlinprogressview.Shape;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u0000 ?2\u00020\u0001:\u0001?B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u00100\u001a\u0002012\n\u00102\u001a\u00020\u0018\"\u00020\nJ\u0012\u00103\u001a\u0002012\b\u00104\u001a\u0004\u0018\u000105H\u0016J\u0012\u00106\u001a\u0002012\b\u00104\u001a\u0004\u0018\u000105H\u0002J\u001a\u00106\u001a\u0002012\b\u00104\u001a\u0004\u0018\u0001052\u0006\u00107\u001a\u00020\bH\u0002J\u0012\u00108\u001a\u0002012\b\u00104\u001a\u0004\u0018\u000105H\u0002J\u0012\u00109\u001a\u0002012\b\u00104\u001a\u0004\u0018\u000105H\u0002J\u0018\u0010:\u001a\u0002012\u0006\u0010;\u001a\u00020\n2\u0006\u0010<\u001a\u00020\nH\u0014J\u0010\u0010=\u001a\u0002012\u0006\u0010\u0019\u001a\u00020\bH\u0002J\b\u0010>\u001a\u000201H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0014\"\u0004\b\u001b\u0010\u0016R&\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\f\"\u0004\b\u001e\u0010\u000eR&\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\f\"\u0004\b!\u0010\u000eR$\u0010#\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\"@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010)\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0014\"\u0004\b+\u0010\u0016R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/shimaami/kotlinprogressview/ProgressView;", "Landroid/view/View;", "contex", "Landroid/content/Context;", "attributeSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "animatedProgress", "", "animationDuration", "", "getAnimationDuration", "()I", "setAnimationDuration", "(I)V", "backgroundPaint", "Landroid/graphics/Paint;", "value", "backgroundWidth", "getBackgroundWidth", "()F", "setBackgroundWidth", "(F)V", "gradientColors", "", "progress", "getProgress", "setProgress", "progressBackgroundColor", "getProgressBackgroundColor", "setProgressBackgroundColor", "progressColor", "getProgressColor", "setProgressColor", "Lcom/shimaami/kotlinprogressview/Direction;", "progressDirection", "getProgressDirection", "()Lcom/shimaami/kotlinprogressview/Direction;", "setProgressDirection", "(Lcom/shimaami/kotlinprogressview/Direction;)V", "progressPaint", "progressWidth", "getProgressWidth", "setProgressWidth", "rectF", "Landroid/graphics/RectF;", "shape", "Lcom/shimaami/kotlinprogressview/Shape;", "applyGradient", "", "colors", "draw", "canvas", "Landroid/graphics/Canvas;", "drawArc", "sweepAngle", "drawCircle", "drawLine", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setProgressWithAnimation", "updateShader", "Companion", "kotlinprogressview_release"})
public class ProgressView
extends View {
    private float progress;
    @NotNull
    private Direction progressDirection;
    private int animationDuration;
    private float backgroundWidth;
    private float progressWidth;
    @ColorInt
    private int progressBackgroundColor;
    @ColorInt
    private int progressColor;
    private final Shape shape;
    private int[] gradientColors;
    private float animatedProgress;
    private final RectF rectF;
    private final Paint backgroundPaint;
    private final Paint progressPaint;
    private static final String PROPERTY_PROGRESS = "ProgressValue";
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    public final float getProgress() {
        return this.progress;
    }

    public final void setProgress(float value) {
        this.setProgressWithAnimation(value);
        this.progress = value;
    }

    @NotNull
    public final Direction getProgressDirection() {
        return this.progressDirection;
    }

    public final void setProgressDirection(@NotNull Direction value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        if (this.progressDirection != value) {
            if (this.gradientColors != null) {
                ArraysKt.reverse((int[])this.gradientColors);
            }
            this.updateShader();
        }
        this.progressDirection = value;
        this.invalidate();
    }

    public final int getAnimationDuration() {
        return this.animationDuration;
    }

    public final void setAnimationDuration(int n) {
        this.animationDuration = n;
    }

    public final float getBackgroundWidth() {
        return this.backgroundWidth;
    }

    public final void setBackgroundWidth(float value) {
        this.backgroundWidth = value;
        this.backgroundPaint.setStrokeWidth(value);
        this.invalidate();
    }

    public final float getProgressWidth() {
        return this.progressWidth;
    }

    public final void setProgressWidth(float value) {
        this.progressWidth = value;
        this.progressPaint.setStrokeWidth(value);
        this.invalidate();
    }

    public final int getProgressBackgroundColor() {
        return this.progressBackgroundColor;
    }

    public final void setProgressBackgroundColor(int value) {
        this.progressBackgroundColor = value;
        this.backgroundPaint.setColor(value);
        this.invalidate();
    }

    public final int getProgressColor() {
        return this.progressColor;
    }

    public final void setProgressColor(int value) {
        this.progressColor = value;
        this.progressPaint.setColor(value);
        this.invalidate();
    }

    public void draw(@Nullable Canvas canvas) {
        super.draw(canvas);
        switch (ProgressView$WhenMappings.$EnumSwitchMapping$0[this.shape.ordinal()]) {
            case 1: {
                this.drawLine(canvas);
                break;
            }
            case 2: {
                this.drawArc(canvas);
                break;
            }
            case 3: {
                this.drawCircle(canvas);
                break;
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int height = View.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        float highStroke = Math.max(this.progressWidth, this.backgroundWidth);
        int min = Math.min(width, height);
        this.rectF.set(highStroke / (float)2, highStroke / (float)2, (float)min - highStroke / (float)2, (float)min - highStroke / (float)2);
        switch (ProgressView$WhenMappings.$EnumSwitchMapping$1[this.shape.ordinal()]) {
            case 1: {
                this.rectF.set(0.0f, highStroke / (float)2, (float)min, highStroke / (float)2);
                this.setMeasuredDimension(width, (int)Math.min(highStroke, (float)height));
                break;
            }
            case 2: {
                this.setMeasuredDimension(min, min / 2);
                break;
            }
            case 3: {
                this.setMeasuredDimension(min, min);
                break;
            }
        }
        this.updateShader();
    }

    private final void setProgressWithAnimation(float progress) {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)PROPERTY_PROGRESS, (float[])new float[]{this.animatedProgress, progress});
        ValueAnimator animator = new ValueAnimator();
        boolean bl = false;
        boolean bl2 = false;
        ValueAnimator $this$with = animator;
        boolean bl3 = false;
        $this$with.setValues(new PropertyValuesHolder[]{propertyValuesHolder});
        $this$with.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        $this$with.setDuration((long)this.animationDuration);
        $this$with.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this, propertyValuesHolder){
            final /* synthetic */ ProgressView this$0;
            final /* synthetic */ PropertyValuesHolder $propertyValuesHolder$inlined;
            {
                this.this$0 = progressView;
                this.$propertyValuesHolder$inlined = propertyValuesHolder;
            }

            public final void onAnimationUpdate(ValueAnimator it) {
                Object object = it.getAnimatedValue("ProgressValue");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                }
                ProgressView.access$setAnimatedProgress$p(this.this$0, ((Float)object).floatValue());
                this.this$0.invalidate();
            }
        });
        $this$with.start();
    }

    public final void applyGradient(int ... colors) {
        Intrinsics.checkParameterIsNotNull((Object)colors, (String)"colors");
        this.gradientColors = colors;
        if (this.progressDirection == Direction.fromRight && this.gradientColors != null) {
            ArraysKt.reverse((int[])this.gradientColors);
        }
        this.updateShader();
    }

    private final void drawArc(Canvas canvas) {
        this.drawArc(canvas, 180.0f);
    }

    private final void drawCircle(Canvas canvas) {
        this.drawArc(canvas, 360.0f);
    }

    private final void drawLine(Canvas canvas) {
        if (canvas == null) {
            return;
        }
        float y = (float)canvas.getHeight() / 2.0f;
        float width = canvas.getWidth();
        float progressWidth = this.animatedProgress * width;
        boolean bl = false;
        boolean bl2 = false;
        Canvas $this$with = canvas;
        boolean bl3 = false;
        $this$with.drawLine(0.0f, y, width, y, this.backgroundPaint);
        if (this.progressDirection == Direction.fromRight) {
            $this$with.drawLine(width, y, width - progressWidth, y, this.progressPaint);
        } else {
            $this$with.drawLine(0.0f, y, progressWidth, y, this.progressPaint);
        }
    }

    private final void drawArc(Canvas canvas, float sweepAngle) {
        block1: {
            float startAngle = 180.0f;
            Canvas canvas2 = canvas;
            if (canvas2 == null) break block1;
            Canvas canvas3 = canvas2;
            boolean bl = false;
            boolean bl2 = false;
            Canvas it = canvas3;
            boolean bl3 = false;
            canvas.drawArc(this.rectF, startAngle, sweepAngle, false, this.backgroundPaint);
            float progressSweepAngle = this.animatedProgress * sweepAngle;
            if (this.progressDirection == Direction.fromRight) {
                startAngle = 0.0f;
                progressSweepAngle = -progressSweepAngle;
            }
            canvas.drawArc(this.rectF, startAngle, progressSweepAngle, false, this.progressPaint);
        }
    }

    private final void updateShader() {
        LinearGradient linearGradient;
        if (this.gradientColors == null) {
            this.progressPaint.setShader((Shader)null);
            this.invalidate();
            return;
        }
        if (this.gradientColors == null) {
            return;
        }
        int[] unwrapedColors = this.gradientColors;
        switch (ProgressView$WhenMappings.$EnumSwitchMapping$2[this.shape.ordinal()]) {
            case 1: {
                linearGradient = new LinearGradient(0.0f, 0.0f, (float)this.getMeasuredWidth(), 0.0f, unwrapedColors, null, Shader.TileMode.CLAMP);
                break;
            }
            case 2: {
                linearGradient = new LinearGradient(0.0f, (float)this.getMeasuredWidth() / 2.0f, (float)this.getMeasuredWidth(), (float)this.getMeasuredHeight(), unwrapedColors, null, Shader.TileMode.CLAMP);
                break;
            }
            case 3: {
                linearGradient = new LinearGradient(0.0f, 0.0f, (float)this.getMeasuredWidth(), (float)this.getMeasuredHeight(), unwrapedColors, null, Shader.TileMode.CLAMP);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        LinearGradient shader = linearGradient;
        this.progressPaint.setShader((Shader)shader);
        this.invalidate();
    }

    public ProgressView(@NotNull Context contex, @NotNull AttributeSet attributeSet) {
        Intrinsics.checkParameterIsNotNull((Object)contex, (String)"contex");
        Intrinsics.checkParameterIsNotNull((Object)attributeSet, (String)"attributeSet");
        super(contex, attributeSet);
        this.progressDirection = Direction.fromLeft;
        this.animationDuration = 1500;
        this.progressBackgroundColor = -16777216;
        this.progressColor = -16777216;
        this.rectF = new RectF();
        this.backgroundPaint = new Paint(1);
        this.progressPaint = new Paint(1);
        TypedArray typedArray = contex.getTheme().obtainStyledAttributes(attributeSet, R.styleable.ProgressView, 0, 0);
        int shapeValue = Shape.arc.getValue();
        boolean bl = false;
        boolean bl2 = false;
        TypedArray $this$with = typedArray;
        boolean bl3 = false;
        int directionValue = $this$with.getInt(R.styleable.ProgressView_pvDirection, Direction.fromLeft.getValue());
        this.setProgressDirection(Direction.Companion.getByValue$kotlinprogressview_release(directionValue));
        shapeValue = $this$with.getInt(R.styleable.ProgressView_pvShape, shapeValue);
        this.setProgress($this$with.getFloat(R.styleable.ProgressView_pvProgress, this.progress));
        this.setBackgroundWidth($this$with.getDimension(R.styleable.ProgressView_pvBackgroundWidth, ProgressViewKt.toPx(2)));
        this.setProgressWidth($this$with.getDimension(R.styleable.ProgressView_pvProgressWidth, ProgressViewKt.toPx(10)));
        this.setProgressBackgroundColor($this$with.getColor(R.styleable.ProgressView_pvBackgroundColor, -16777216));
        this.setProgressColor($this$with.getColor(R.styleable.ProgressView_pvProgressColor, -65536));
        this.animationDuration = $this$with.getInt(R.styleable.ProgressView_pvAnimateDuration, this.animationDuration);
        $this$with.recycle();
        this.shape = Shape.Companion.getByValue$kotlinprogressview_release(shapeValue);
        this.backgroundPaint.setStyle(Paint.Style.STROKE);
        this.progressPaint.setStyle(Paint.Style.STROKE);
    }

    public static final /* synthetic */ float access$getAnimatedProgress$p(ProgressView $this) {
        return $this.animatedProgress;
    }

    public static final /* synthetic */ void access$setAnimatedProgress$p(ProgressView $this, float f) {
        $this.animatedProgress = f;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/shimaami/kotlinprogressview/ProgressView$Companion;", "", "()V", "PROPERTY_PROGRESS", "", "kotlinprogressview_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

