/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.shield.android.CaptchaType;
import com.shield.android.R;
import com.shield.android.internal.InternalLogger;
import com.shield.android.internal.Utils;
import java.io.Serializable;
import java.util.Random;

public class CaptchaDialog
extends Activity {
    private static final String CAPTCHA_TYPE = "captcha_type";
    public static final String CAPTCHA_BROADCAST = "captcha_broadcast";
    public static final String QUITTABLE = "quittable";
    private CaptchaType captchaType = CaptchaType.TEXT_CAPTCHA;
    private LocalBroadcastManager localBroadcastManager;
    private ImageView captchaImageView;
    private EditText captchaEditText;
    private TextView captchaSubtitle;
    private TextView captchaTitle;
    private TextView captchaError;
    private String drawText = "";
    private int challengeTotal = -1;
    private int retryCount = 0;

    public static Intent getCaptchaIntent(Context context, CaptchaType captchaType, boolean quittable) {
        Intent intent = new Intent(context, CaptchaDialog.class);
        intent.putExtra(CAPTCHA_TYPE, (Serializable)((Object)captchaType));
        intent.putExtra(QUITTABLE, quittable);
        return intent;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.setContentView(R.layout.dialog_captcha);
        this.setFinishOnTouchOutside(false);
        this.localBroadcastManager = LocalBroadcastManager.getInstance((Context)this);
        this.captchaImageView = (ImageView)this.findViewById(R.id.captchaImage);
        this.captchaEditText = (EditText)this.findViewById(R.id.captchaEditText);
        this.captchaSubtitle = (TextView)this.findViewById(R.id.subtitle);
        this.captchaTitle = (TextView)this.findViewById(R.id.title);
        this.captchaError = (TextView)this.findViewById(R.id.error);
        try {
            this.captchaType = (CaptchaType)((Object)this.getIntent().getSerializableExtra(CAPTCHA_TYPE));
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
        }
        if (this.captchaType == CaptchaType.TEXT_CAPTCHA) {
            this.captchaTitle.setText((CharSequence)"Captcha");
            this.captchaSubtitle.setText(R.string.label_captcha_subtitle);
            this.captchaError.setText(R.string.label_captcha_message);
            this.drawText = Utils.randomString();
            this.captchaImageView.setImageBitmap(Utils.drawRandomStringOnBitmap(this.drawText));
        } else if (this.captchaType == CaptchaType.MATH_CHALLENGE) {
            this.captchaTitle.setText((CharSequence)"Math Challenge");
            this.captchaSubtitle.setText(R.string.label_challenge_subtitle);
            this.captchaError.setText(R.string.label_challenge_message);
            this.captchaEditText.setInputType(2);
            int firstNo = new Random().nextInt(10);
            int secondNo = new Random().nextInt(10);
            this.challengeTotal = firstNo + secondNo;
            this.captchaImageView.setImageBitmap(Utils.drawChallengeOnBitmap(firstNo, secondNo));
        }
        this.captchaEditText.setOnEditorActionListener((v, actionId, event) -> {
            if (actionId == 6) {
                if (this.captchaType == CaptchaType.TEXT_CAPTCHA) {
                    if (!this.captchaEditText.getText().toString().equals(this.drawText)) {
                        ++this.retryCount;
                        if (this.retryCount > 3) {
                            Intent i = new Intent(CAPTCHA_BROADCAST);
                            i.putExtra("RESULT_OK", false);
                            this.localBroadcastManager.sendBroadcast(i);
                            this.finish();
                        }
                        this.captchaError.setVisibility(0);
                        this.drawText = Utils.randomString();
                        this.captchaImageView.setImageBitmap(Utils.drawRandomStringOnBitmap(this.drawText));
                    } else {
                        new Handler().postDelayed(() -> {
                            Intent i = new Intent(CAPTCHA_BROADCAST);
                            i.putExtra("RESULT_OK", true);
                            this.localBroadcastManager.sendBroadcast(i);
                            this.finish();
                        }, 200L);
                    }
                } else {
                    try {
                        if (Integer.parseInt(this.captchaEditText.getText().toString()) != this.challengeTotal) {
                            ++this.retryCount;
                            if (this.retryCount > 3) {
                                Intent i = new Intent(CAPTCHA_BROADCAST);
                                i.putExtra("RESULT_OK", false);
                                this.localBroadcastManager.sendBroadcast(i);
                                this.finish();
                            }
                            this.captchaError.setVisibility(0);
                            int firstNo = new Random().nextInt(10);
                            int secondNo = new Random().nextInt(10);
                            this.challengeTotal = firstNo + secondNo;
                            this.captchaImageView.setImageBitmap(Utils.drawChallengeOnBitmap(firstNo, secondNo));
                        } else {
                            new Handler().postDelayed(() -> {
                                Intent i = new Intent(CAPTCHA_BROADCAST);
                                i.putExtra("RESULT_OK", true);
                                this.localBroadcastManager.sendBroadcast(i);
                                this.finish();
                            }, 200L);
                        }
                    }
                    catch (Exception e) {
                        InternalLogger.getInstance().error(e);
                    }
                }
                return false;
            }
            return false;
        });
    }

    public void onBackPressed() {
    }
}

