/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.rootchecker;

import com.shield.android.BuildConfig;
import com.shield.android.internal.InternalLogger;
import com.shield.android.internal.NativeUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;
import org.json.JSONObject;

public class RootChecker {
    private NativeUtils nativeUtils;
    private String[] blackListedMountPaths = new String[]{"/sbin/.magisk/", "/sbin/.core/mirror", "/sbin/.core/img", "/sbin/.core/db-0/magisk.db"};
    boolean detectedDevKeys;
    boolean detectedTestKeys;
    boolean notFoundReleaseKeys;
    boolean foundDangerousProps;
    boolean permissiveSELinux;
    boolean suExists;
    boolean accessedSuperuserApk;
    boolean foundSuBinary;
    boolean foundBusyboxBinary;
    boolean foundXposed;
    boolean foundResetProp;
    boolean foundWrongPathPermission;
    boolean foundMagisk;
    boolean foundSuCommand;

    public RootChecker(NativeUtils nativeUtils) {
        this.nativeUtils = nativeUtils;
        if (nativeUtils.isLibraryLoaded()) {
            try {
                nativeUtils.setLogDebugMessages(BuildConfig.DEBUG);
                this.detectedDevKeys = nativeUtils.isDetectedDevKeys();
                this.detectedTestKeys = nativeUtils.isDetectedTestKeys();
                this.notFoundReleaseKeys = nativeUtils.isNotFoundReleaseKeys();
                this.foundDangerousProps = nativeUtils.isFoundDangerousProps();
                this.permissiveSELinux = nativeUtils.isPermissiveSelinux();
                this.suExists = nativeUtils.isSuExists();
                this.accessedSuperuserApk = nativeUtils.isAccessedSuperuserApk();
                this.foundSuBinary = nativeUtils.isFoundSuBinary();
                this.foundBusyboxBinary = nativeUtils.isFoundBusyboxBinary();
                this.foundXposed = nativeUtils.isFoundXposed();
                this.foundResetProp = nativeUtils.isFoundResetprop();
                this.foundWrongPathPermission = nativeUtils.isFoundWrongPathPermission();
                this.foundMagisk = this.isFoundMagisk();
                this.foundSuCommand = this.isFoundSuCommand();
            }
            catch (Exception e) {
                InternalLogger.getInstance().error(e);
            }
        } else {
            InternalLogger.getInstance().debug("Something went wrong loading library", new Object[0]);
        }
    }

    public boolean shouldRunFridaListener() {
        return this.suExists || this.accessedSuperuserApk || this.foundSuBinary || this.foundXposed || this.foundResetProp || this.foundMagisk || this.foundWrongPathPermission;
    }

    public String isRooted() {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("isDetectedDevKeys", this.detectedDevKeys);
            jsonObject.put("isDetectedTestKeys", this.detectedTestKeys);
            jsonObject.put("isNotFoundReleaseKeys", this.notFoundReleaseKeys);
            jsonObject.put("isFoundDangerousProps", this.foundDangerousProps);
            jsonObject.put("isPermissiveSelinux", this.permissiveSELinux);
            jsonObject.put("isSuExists", this.suExists);
            jsonObject.put("isAccessedSuperuserApk", this.accessedSuperuserApk);
            jsonObject.put("isFoundSuBinary", this.foundSuBinary);
            jsonObject.put("isFoundBusyboxBinary", this.foundBusyboxBinary);
            jsonObject.put("isFoundXposed", this.foundXposed);
            jsonObject.put("isFoundResetprop", this.foundResetProp);
            jsonObject.put("isFoundWrongPathPermission", this.foundWrongPathPermission);
            jsonObject.put("isFoundMagisk", this.foundMagisk);
            jsonObject.put("isSuCommandFound", this.foundSuCommand);
            return jsonObject.toString();
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
            return "";
        }
    }

    private boolean isFoundMagisk() {
        boolean isMagiskPresent = false;
        int pid = android.os.Process.myPid();
        String cwd = String.format(Locale.ENGLISH, "/proc/%d/mounts", pid);
        File file = new File(cwd);
        try {
            String str;
            FileInputStream fis = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
            int count = 0;
            while ((str = reader.readLine()) != null) {
                for (String path : this.blackListedMountPaths) {
                    if (!str.contains(path)) continue;
                    InternalLogger.getInstance().debug("Blacklisted Path found " + path, new Object[0]);
                    ++count;
                }
            }
            reader.close();
            fis.close();
            InternalLogger.getInstance().debug("Count of paths " + count, new Object[0]);
            if (count > 1) {
                InternalLogger.getInstance().debug("Found at least more than 1 path ", new Object[0]);
                isMagiskPresent = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isMagiskPresent || this.nativeUtils.isFoundMagisk();
    }

    private boolean isFoundSuCommand() {
        try {
            int read;
            Process process = Runtime.getRuntime().exec("which su");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            char[] buffer = new char[4096];
            StringBuilder output = new StringBuilder();
            while ((read = reader.read(buffer)) > 0) {
                output.append(buffer, 0, read);
            }
            reader.close();
            process.waitFor();
            return output.toString().length() > 0;
        }
        catch (Exception ignored) {
            return false;
        }
    }
}

