/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.repository;

import android.os.Handler;
import android.os.Looper;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.shield.android.ShieldCallback;
import com.shield.android.ShieldException;
import com.shield.android.context.ShieldContext;
import com.shield.android.internal.CSLogger;
import com.shield.android.internal.Config;
import com.shield.android.internal.InternalLogger;
import com.shield.android.internal.URLWrapperCallable;
import com.shield.android.nettask.APICountNetTask;
import com.shield.android.nettask.GetRiskAssessmentNetTask;
import com.shield.android.nettask.NetTaskQueue;
import com.shield.android.nettask.SendAttributesNetTask;
import com.shield.android.nettask.SendDeviceSignatureNetTask;
import com.shield.android.nettask.UpdateCaptchaNetTask;
import com.shield.android.repository.IShieldRepository;
import com.shield.android.repository.URLProvider;
import java.util.HashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import org.json.JSONObject;

public class ShieldRepositoryImpl
implements IShieldRepository {
    protected static final String SESSION_ID = "session_id";
    protected static final String SITE_ID = "site_id";
    protected final NetTaskQueue netTaskQueue;
    protected String siteId;
    protected String sessionId;
    protected String secretKey;
    protected final ShieldContext shieldContext;
    protected final ExecutorService contextExecutor;
    protected final GetRiskAssessmentNetTask getRiskAssessmentNetTask;
    private final UpdateCaptchaNetTask updateCaptchaNetTask;
    private final SendAttributesNetTask sendAttributesNetTask;
    private final SendDeviceSignatureNetTask sendDeviceSignatureNetTask;
    private final URLProvider urlProvider;
    private final APICountNetTask apiCountNetTask;
    protected final CSLogger logger;
    private String partnerId;

    public ShieldRepositoryImpl(String siteId, String sessionId, String secretKey, String partnerId, NetTaskQueue netTaskQueue, GetRiskAssessmentNetTask getRiskAssessmentNetTask, SendDeviceSignatureNetTask sendDeviceSignatureNetTask, SendAttributesNetTask sendAttributesNetTask, UpdateCaptchaNetTask updateCaptchaNetTask, APICountNetTask apiCountNetTask, ShieldContext shieldContext, ExecutorService contextExecutor, URLProvider urlProvider, CSLogger logger) {
        this.netTaskQueue = netTaskQueue;
        this.getRiskAssessmentNetTask = getRiskAssessmentNetTask;
        this.sendDeviceSignatureNetTask = sendDeviceSignatureNetTask;
        this.sendAttributesNetTask = sendAttributesNetTask;
        this.updateCaptchaNetTask = updateCaptchaNetTask;
        this.apiCountNetTask = apiCountNetTask;
        this.shieldContext = shieldContext;
        this.contextExecutor = contextExecutor;
        this.siteId = siteId;
        this.logger = logger;
        this.sessionId = sessionId;
        this.secretKey = secretKey;
        this.urlProvider = urlProvider;
        this.partnerId = partnerId;
    }

    @Override
    public void sendAttributes(@NonNull String screenName, @Nullable HashMap<String, String> data) {
        this.internalSendAttributes(screenName, data, null);
    }

    @Override
    public void sendAttributes(@NonNull String screenName, @Nullable HashMap<String, String> data, @NonNull ShieldCallback<Boolean> shieldCallback) {
        this.internalSendAttributes(screenName, data, shieldCallback);
    }

    @Override
    public void sendDeviceSignature(final @NonNull String screenName, final @Nullable HashMap<String, String> data, final @NonNull ShieldCallback<Pair<Config, JSONObject>> shieldCallback) {
        this.executeUrl(new URLWrapperCallable(){

            @Override
            public Void call() {
                return ShieldRepositoryImpl.this.sendDeviceSignature(this.baseUrl, this.version, screenName, data, shieldCallback);
            }
        });
    }

    private void internalSendAttributes(final @NonNull String screenName, final @Nullable HashMap<String, String> data, final @Nullable ShieldCallback<Boolean> shieldCallback) {
        this.executeUrl(new URLWrapperCallable(){

            @Override
            public Void call() {
                return ShieldRepositoryImpl.this.internalSendAttributes(this.baseUrl, this.version, screenName, data, shieldCallback);
            }
        });
    }

    @Override
    public void updateChallenge(final boolean result) {
        this.executeUrl(new URLWrapperCallable(){

            @Override
            public Void call() {
                return ShieldRepositoryImpl.this.updateChallenge(this.baseUrl, this.version, result);
            }
        });
    }

    @Override
    public void sendAPICount() {
        this.executeUrl(new URLWrapperCallable(){

            @Override
            public Void call() {
                return ShieldRepositoryImpl.this.sendAPICount(this.baseUrl, this.version);
            }
        });
    }

    private void executeUrl(final URLWrapperCallable func) {
        try {
            this.urlProvider.getUrl(new ShieldCallback<Pair<String, String>>(){

                @Override
                public void onSuccess(@Nullable Pair<String, String> urlPair) {
                    try {
                        if (urlPair != null) {
                            func.setBaseUrl((String)urlPair.first);
                            func.setVersion((String)urlPair.second);
                        }
                        func.call();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                @Override
                public void onFailure(@Nullable ShieldException ignored) {
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Void sendDeviceSignature(String baseUrl, String version, @NonNull String screenName, @Nullable HashMap<String, String> data, @NonNull ShieldCallback<Pair<Config, JSONObject>> shieldCallback) {
        this.sendDeviceSignatureNetTask.setBaseUrl(baseUrl);
        this.sendDeviceSignatureNetTask.setVersion(version);
        this.sendDeviceSignatureNetTask.setRequestHeaders("Fp-Trigger-Time", String.valueOf(System.currentTimeMillis()));
        Looper currentLooper = Looper.myLooper();
        Thread oldThread = Thread.currentThread();
        try {
            this.contextExecutor.submit(() -> {
                ConcurrentMap<String, String> map = this.shieldContext.getShieldContext();
                HashMap<String, Object> params = new HashMap<String, Object>(map);
                params.put("SCREEN_NAME", screenName);
                if (this.partnerId != null && this.partnerId.length() > 0) {
                    params.put("partner_id", this.partnerId);
                }
                if (data != null) {
                    params.putAll(data);
                }
                this.sendDeviceSignatureNetTask.setRequestObject(params);
                this.netTaskQueue.enqueue(this.sendDeviceSignatureNetTask, state -> {
                    if (state == NetTaskQueue.State.FINISHED) {
                        if (currentLooper == null || currentLooper != Looper.getMainLooper()) {
                            new Thread(() -> {
                                if (this.sendDeviceSignatureNetTask.responseError != null) {
                                    shieldCallback.onFailure(this.sendDeviceSignatureNetTask.responseError);
                                } else {
                                    Pair resultPair = new Pair((Object)this.sendDeviceSignatureNetTask.config, (Object)this.sendDeviceSignatureNetTask.deviceResult);
                                    shieldCallback.onSuccess(resultPair);
                                }
                            }, oldThread.getName()).start();
                        } else {
                            new Handler(currentLooper).post(() -> {
                                if (this.sendDeviceSignatureNetTask.responseError != null) {
                                    shieldCallback.onFailure(this.sendDeviceSignatureNetTask.responseError);
                                } else {
                                    Pair resultPair = new Pair((Object)this.sendDeviceSignatureNetTask.config, (Object)this.sendDeviceSignatureNetTask.deviceResult);
                                    shieldCallback.onSuccess(resultPair);
                                }
                            });
                        }
                    }
                });
            });
        }
        catch (Exception e) {
            shieldCallback.onFailure(ShieldException.unexpectedError(e));
        }
        return null;
    }

    private Void updateChallenge(String baseUrl, String version, boolean result) {
        try {
            this.updateCaptchaNetTask.setBaseUrl(baseUrl);
            this.updateCaptchaNetTask.setVersion(version);
            this.updateCaptchaNetTask.setCaptchaSuccess(result);
            this.netTaskQueue.enqueue(this.updateCaptchaNetTask);
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
        }
        return null;
    }

    private Void sendAPICount(String baseUrl, String version) {
        try {
            this.apiCountNetTask.setBaseUrl(baseUrl);
            this.apiCountNetTask.setVersion(version);
            this.netTaskQueue.enqueue(this.apiCountNetTask);
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
        }
        return null;
    }

    private Void internalSendAttributes(String baseUrl, String version, @NonNull String screenName, @Nullable HashMap<String, String> data, @Nullable ShieldCallback<Boolean> shieldCallback) {
        block2: {
            this.sendAttributesNetTask.setBaseUrl(baseUrl);
            this.sendAttributesNetTask.setVersion(version);
            Looper currentLooper = Looper.myLooper();
            Thread oldThread = Thread.currentThread();
            try {
                this.contextExecutor.submit(() -> {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("screen_name", screenName);
                    params.put(SITE_ID, this.siteId);
                    if (this.partnerId != null && this.partnerId.length() > 0) {
                        params.put("partner_id", this.partnerId);
                    }
                    params.put(SESSION_ID, this.sessionId);
                    if (data != null) {
                        for (String key : data.keySet()) {
                            if (key == null) continue;
                            params.put(key.toLowerCase(), data.get(key));
                        }
                    }
                    this.sendAttributesNetTask.setRequestObject(params);
                    if (shieldCallback != null) {
                        this.netTaskQueue.enqueue(this.sendAttributesNetTask, state -> {
                            if (state == NetTaskQueue.State.FINISHED) {
                                if (currentLooper == null || currentLooper != Looper.getMainLooper()) {
                                    new Thread(() -> {
                                        if (this.sendAttributesNetTask.responseError != null) {
                                            shieldCallback.onFailure(this.sendAttributesNetTask.responseError);
                                        } else {
                                            shieldCallback.onSuccess(this.sendAttributesNetTask.status);
                                        }
                                    }, oldThread.getName()).start();
                                } else {
                                    new Handler(currentLooper).post(() -> {
                                        if (this.sendAttributesNetTask.responseError != null) {
                                            shieldCallback.onFailure(this.sendAttributesNetTask.responseError);
                                        } else {
                                            shieldCallback.onSuccess(this.sendAttributesNetTask.status);
                                        }
                                    });
                                }
                            }
                        });
                    } else {
                        this.netTaskQueue.enqueue(this.sendAttributesNetTask);
                    }
                });
            }
            catch (Exception e) {
                if (shieldCallback == null) break block2;
                shieldCallback.onFailure(ShieldException.unexpectedError(e));
            }
        }
        return null;
    }
}

