/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.repository;

import android.content.SharedPreferences;
import android.util.Pair;
import com.shield.android.ShieldCallback;
import com.shield.android.ShieldException;
import com.shield.android.nettask.NetTaskQueue;
import com.shield.android.nettask.ServiceDiscoveryNetTask;
import com.shield.android.repository.URLRepository;

public class NetworkURLRepository
implements URLRepository {
    private final ServiceDiscoveryNetTask serviceDiscoveryNetTask;
    private final NetTaskQueue netTaskQueue;
    private final SharedPreferences sharedPreferences;

    public NetworkURLRepository(ServiceDiscoveryNetTask serviceDiscoveryNetTask, NetTaskQueue netTaskQueue, SharedPreferences sharedPreferences) {
        this.serviceDiscoveryNetTask = serviceDiscoveryNetTask;
        this.netTaskQueue = netTaskQueue;
        this.sharedPreferences = sharedPreferences;
    }

    @Override
    public void getUrl(ShieldCallback<Pair<String, String>> callback) {
        this.netTaskQueue.enqueue(this.serviceDiscoveryNetTask, state -> {
            try {
                if (state == NetTaskQueue.State.FINISHED) {
                    if (this.serviceDiscoveryNetTask.responseError == null) {
                        String endpoint = this.serviceDiscoveryNetTask.result.getString("endpoint");
                        int version = this.serviceDiscoveryNetTask.result.optInt("version", 1);
                        this.sharedPreferences.edit().putString("endpoint", endpoint).apply();
                        this.sharedPreferences.edit().putString("version", String.valueOf(version)).apply();
                        Pair urlPair = new Pair((Object)endpoint, (Object)String.valueOf(version));
                        callback.onSuccess(urlPair);
                    } else {
                        callback.onFailure(this.serviceDiscoveryNetTask.responseError);
                    }
                }
            }
            catch (Exception e) {
                callback.onFailure(ShieldException.unexpectedError(e));
            }
        });
    }
}

