/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.nettask;

import com.shield.android.ShieldException;
import com.shield.android.internal.InternalLogger;
import com.shield.android.nettask.HMACUtils;
import com.shield.android.nettask.NetTask;
import java.util.HashMap;
import java.util.Map;

public final class UpdateCaptchaNetTask
extends NetTask {
    private String sessionId;
    private String version;
    private String siteId;
    private String secretKey;
    private String baseUrl;
    private int captchaSuccess = 0;

    public UpdateCaptchaNetTask(String siteId, String secretKey, String sessionId) {
        this.sessionId = sessionId;
        this.siteId = siteId;
        this.secretKey = secretKey;
    }

    @Override
    protected HashMap<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        long timeStamp = System.currentTimeMillis() / 1000L;
        headers.put("Timestamp", String.valueOf(timeStamp));
        headers.put("Site-Id", this.siteId);
        String shieldSignature = HMACUtils.getShieldSignature(timeStamp, this.siteId, this.secretKey);
        headers.put("Shield-Signature", shieldSignature.toLowerCase());
        return headers;
    }

    @Override
    protected String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    protected String getSiteId() {
        return this.siteId;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    protected String getVersion() {
        return this.version;
    }

    public void setCaptchaSuccess(boolean isCaptchaSuccess) {
        this.captchaSuccess = isCaptchaSuccess ? 1 : 0;
    }

    @Override
    protected String getUrl() {
        return String.format("/shield-fp/v1/api/intelligence/%s?recaptcha=%d", this.sessionId, this.captchaSuccess);
    }

    @Override
    protected NetTask.Method getMethod() {
        return NetTask.Method.PUT;
    }

    @Override
    protected NetTask.RequestType getRequestType() {
        return NetTask.RequestType.TEXT;
    }

    @Override
    protected Map<String, Object> getRequestObject() {
        return new HashMap<String, Object>();
    }

    @Override
    protected void onSuccess(String response) {
    }

    @Override
    protected void onFail(ShieldException exception) {
        InternalLogger.getInstance().error(exception);
    }
}

