/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.nettask;

import com.shield.android.internal.InternalLogger;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.URI;
import java.util.List;

public final class ShieldCookieManager {
    private static ShieldCookieManager sharedInstance = null;
    private CookieManager mCookieManager = new CookieManager();

    public static void initialize() {
        if (sharedInstance == null) {
            sharedInstance = new ShieldCookieManager();
        }
    }

    public static ShieldCookieManager getInstance() {
        if (sharedInstance == null) {
            sharedInstance = new ShieldCookieManager();
        }
        return sharedInstance;
    }

    private ShieldCookieManager() {
        this.mCookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ORIGINAL_SERVER);
        CookieHandler.setDefault(this.mCookieManager);
    }

    private List<HttpCookie> getCookies() {
        if (this.mCookieManager == null) {
            return null;
        }
        return this.mCookieManager.getCookieStore().getCookies();
    }

    public List<HttpCookie> getCookies(String url) {
        if (this.mCookieManager == null) {
            return null;
        }
        return this.mCookieManager.getCookieStore().getCookies();
    }

    public void storeCookies(String url, List<HttpCookie> cookies) {
        for (HttpCookie cookie : cookies) {
            if (this.mCookieManager == null) continue;
            try {
                this.mCookieManager.getCookieStore().add(URI.create(url), cookie);
            }
            catch (Exception e) {
                InternalLogger.getInstance().error(e);
            }
        }
    }

    public void clearCookies() {
        if (this.mCookieManager != null) {
            this.mCookieManager.getCookieStore().removeAll();
        }
    }

    public boolean isCookieManagerEmpty() {
        if (this.mCookieManager == null) {
            return true;
        }
        return this.mCookieManager.getCookieStore().getCookies().isEmpty();
    }

    public String getCookieValue() {
        String cookieValue = new String();
        if (!this.isCookieManagerEmpty()) {
            for (HttpCookie eachCookie : this.getCookies()) {
                cookieValue = cookieValue + String.format("%s=%s, host: %s, path: %s;", eachCookie.getName(), eachCookie.getValue(), eachCookie.getDomain(), eachCookie.getPath());
            }
        }
        return cookieValue;
    }
}

