/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.nettask;

import com.shield.android.ShieldException;
import com.shield.android.internal.CSLogger;
import com.shield.android.internal.InternalLogger;
import com.shield.android.nettask.HMACUtils;
import com.shield.android.nettask.NetTask;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class ServiceDiscoveryNetTask
extends NetTask {
    private String version;
    private final String siteId;
    private final String secretKey;
    private final Map<String, Object> params = new HashMap<String, Object>();
    private final CSLogger logger;
    public JSONObject result;
    public ShieldException responseError;

    public ServiceDiscoveryNetTask(String siteId, String secretKey, CSLogger logger) {
        this.siteId = siteId;
        this.secretKey = secretKey;
        this.logger = logger;
    }

    @Override
    protected HashMap<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        long timeStamp = System.currentTimeMillis() / 1000L;
        headers.put("Timestamp", String.valueOf(timeStamp));
        headers.put("Site-Id", this.siteId);
        String shieldSignature = HMACUtils.getShieldSignature(timeStamp, this.siteId, this.secretKey);
        headers.put("Shield-Signature", shieldSignature);
        return headers;
    }

    @Override
    protected String getBaseUrl() {
        return "https://service-discovery.shield.com/";
    }

    @Override
    protected String getUrl() {
        return String.format("/discovery/v1/endpoint?sid=%s", this.siteId);
    }

    @Override
    protected NetTask.Method getMethod() {
        return NetTask.Method.GET;
    }

    @Override
    protected NetTask.RequestType getRequestType() {
        return null;
    }

    @Override
    protected Map<String, Object> getRequestObject() {
        return null;
    }

    @Override
    public void setBaseUrl(String baseUrl) {
    }

    @Override
    protected String getSiteId() {
        return this.siteId;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    protected String getVersion() {
        return this.version;
    }

    @Override
    protected void onSuccess(String response) {
        try {
            this.responseError = null;
            InternalLogger.getInstance().info(response, new Object[0]);
            this.result = new JSONObject(response);
        }
        catch (Exception e) {
            this.responseError = ShieldException.unexpectedError(e);
        }
    }

    @Override
    protected void onFail(ShieldException exception) {
        if (exception.kind == ShieldException.Kind.HTTP) {
            this.logger.error(exception, "%s - %s", exception.message, exception.body);
        } else {
            this.logger.error(exception, exception.message, new Object[0]);
        }
        this.responseError = exception;
    }
}

