/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.nettask;

import com.shield.android.ShieldException;
import com.shield.android.internal.CSLogger;
import com.shield.android.internal.Config;
import com.shield.android.internal.CryptoUtils;
import com.shield.android.internal.InternalLogger;
import com.shield.android.nettask.NetTask;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class SendDeviceSignatureNetTask
extends NetTask {
    public JSONObject deviceResult = new JSONObject();
    public Config config;
    private final HashMap<String, Object> params = new HashMap();
    private final CSLogger logger;
    private static final String FT_MOBILE = "send-event.php";
    private final CryptoUtils cryptoUtils;
    private Map<String, Object> currentParams;
    public boolean status = false;
    public ShieldException responseError;
    private String environment;
    private String baseUrl;
    private HashMap<String, String> headers = new HashMap();
    private String siteId;
    private String version;

    public SendDeviceSignatureNetTask(String siteId, CSLogger logger, CryptoUtils cryptoUtils, String environment) {
        this.siteId = siteId;
        this.logger = logger;
        this.cryptoUtils = cryptoUtils;
        this.environment = environment;
        this.headers.put("Accept-Encoding", "gzip");
    }

    public void setRequestHeaders(String key, String value) {
        this.headers.put(key, value);
    }

    @Override
    public HashMap<String, String> getRequestHeaders() {
        return this.headers;
    }

    @Override
    protected String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    protected String getSiteId() {
        return this.siteId;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    protected String getVersion() {
        return this.version;
    }

    @Override
    public String getUrl() {
        String url = String.format("/wfp/%s", FT_MOBILE).toLowerCase();
        return url;
    }

    @Override
    public NetTask.Method getMethod() {
        return NetTask.Method.POST;
    }

    @Override
    public NetTask.RequestType getRequestType() {
        return NetTask.RequestType.TEXT;
    }

    public void setRequestObject(Map<String, Object> requestObject) {
        String encryptedPayload = "";
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("test", this.environment != null && this.environment.equalsIgnoreCase("Dev"));
            for (Map.Entry<String, Object> entry : requestObject.entrySet()) {
                if (entry.getValue() != null) {
                    jsonObject.put(entry.getKey(), (Object)entry.getValue().toString());
                    continue;
                }
                jsonObject.put(entry.getKey(), JSONObject.NULL);
            }
            String payload = jsonObject.toString();
            encryptedPayload = this.cryptoUtils.encryptPayload(payload);
        }
        catch (Exception e) {
            this.logger.error(e, "error serializing data", new Object[0]);
        }
        this.params.clear();
        this.params.put("data", encryptedPayload);
    }

    @Override
    public Map<String, Object> getRequestObject() {
        return this.params;
    }

    @Override
    public void onFail(ShieldException exception) {
        if (exception.kind == ShieldException.Kind.HTTP) {
            this.logger.error(exception, "%s - %s", exception.message, exception.body);
        } else {
            this.logger.error(exception, exception.message, new Object[0]);
        }
        this.responseError = exception;
    }

    @Override
    public void onSuccess(String response) {
        try {
            this.responseError = null;
            JSONObject responseResult = new JSONObject(response);
            this.status = responseResult.getBoolean("status");
            String code = responseResult.optString("code", "");
            if (this.config == null) {
                this.config = new Config();
            }
            boolean autoBlock = responseResult.optBoolean("auto_block", this.config.autoBlock);
            boolean autoCaptcha = responseResult.optBoolean("auto_captcha", this.config.autoCaptcha);
            boolean callback = responseResult.optBoolean("callback", this.config.callback);
            long featureVersion = responseResult.optLong("feature_version", this.config.featureVersion);
            this.config.autoBlock = autoBlock;
            this.config.autoCaptcha = autoCaptcha;
            this.config.callback = callback;
            this.config.featureVersion = featureVersion;
            if (code.equals("001")) {
                this.deviceResult = responseResult.optJSONObject("result");
            } else {
                this.responseError = ShieldException.unexpectedError(new Throwable(responseResult.optString("message")));
            }
        }
        catch (JSONException e) {
            this.responseError = ShieldException.unexpectedError(e);
            InternalLogger.getInstance().error(e);
        }
    }
}

